<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\TMtotalsew;
use App\TMgenerate;
use App\TMcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;

/**
 * Class DashboardController.
 */
class SetPriceBleachController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        abort_unless(\Gate::allows('order_access'), 403);
        $order = Torder_hd::select(
                        'Torder_hd.XVOrderDocNo',
                        'Torder_hd.XVOrderIn',
                        'Torder_hd.XVOrderDetail',
                        'Torder_hd.XIAddBlenchCode',
                        'Torder_hd.XDOrderBPrince',
                        'TMblench.XVBlenchName'
                )
                ->leftJoin('TMblench','TMblench.XIBlenchCode','=','Torder_hd.XIAddBlenchCode')
                ->orderBy('Torder_hd.XTWhenCreate','desc')
                ->get();

        return view('admin.setpricebleach.index',compact('order',$order));
    }

    public function create()
    {
        abort(404);
        //return view('admin.setpricebleach.create');
    }

    public function edit($docNo)
    {
        abort_unless(\Gate::allows('order_edit'), 403);
            $order = Torder_hd::select(
                                'Torder_hd.XVOrderDocNo',
                                'Torder_hd.XVOrderIn',
                                'Torder_hd.XVOrderDetail',
                                'Torder_hd.XIAddBlenchCode',
                                'Torder_hd.XDOrderBPrince',
                                'TMblench.XVBlenchName'
                        )
                        ->leftJoin('TMblench','TMblench.XIBlenchCode','=','Torder_hd.XIAddBlenchCode')
                        ->where('Torder_hd.XVOrderDocNo',$docNo)
                        ->orderBy('Torder_hd.XTWhenCreate','desc')
                        ->first();

        return view('admin.setpricebleach.edit', compact('order',$order));
    }

    public function update(request $request)
    {
        abort_unless(\Gate::allows('order_edit'), 403);

        $OrderHD_update = [
            'XDOrderBPrince'      => $request->XDOrderBPrince
        ];
        Torder_hd::updateorder_id($request->XVOrderDocNo, $OrderHD_update);

        return redirect()->route('admin.setpricebleach.index');
    }


}
