<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyShapeRequest;
use App\Http\Requests\StoreShapeRequest;
use App\Http\Requests\UpdateShapeRequest;
use App\tmshape;

use Illuminate\Support\Facades\Auth;

class ShapeController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('shape_access'), 403);

        $shape = tmshape::get();

        return view('admin.shape.index', compact('shape'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('shape_create'), 403);

        return view('admin.shape.create');
    }

    public function store(StoreShapeRequest $request)
    {

        abort_unless(\Gate::allows('shape_create'), 403);

        // $docid = GennarateidController::Gent5id("tmshape", "XIShapeCode");

        //add request
        // $request->request->add(['XIShapeCode' => $docid]);
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $shape = tmshape::create($request->all());

        return redirect()->route('admin.shape.index');
    }

    public function edit(tmshape $shape)
    {

        abort_unless(\Gate::allows('shape_edit'), 403);

        return view('admin.shape.edit', compact('shape'));
    }

    public function update(UpdateShapeRequest $request, tmshape $shape)
    {

        abort_unless(\Gate::allows('shape_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $shape->update($request->all());

        return redirect()->route('admin.shape.index');
    }

    public function show(tmshape $shape)
    {
        abort_unless(\Gate::allows('shape_show'), 403);

        return view('admin.shape.show', compact('shape'));
    }

    public function destroy(tmshape $shape)
    {
        abort_unless(\Gate::allows('shape_delete'), 403);

        $shape->update(['XVWhoEdit' => Auth::user()->name]);
        $shape->delete();

        return back();
    }

    public function massDestroy(MassDestroyShapeRequest $request)
    {
        abort_unless(\Gate::allows('shape_delete'), 403);

        //add request
        tmshape::whereIn('XIShapeCode', request('ids'))->update(['XVWhoEdit' => Auth::user()->name]);
        tmshape::whereIn('XIShapeCode', request('ids'))->delete();

        return response(null, 204);
    }
}
