<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Auth;
use PDF;

use App\TMtotalsew;
use App\tmgenerate;
use App\tmcustomer;
use App\Tdocprexp;
use App\Torder_hd;
use App\Torder_dt;
use App\Torder_bc;
use App\TMblench;
use App\tmforuse;
use App\TMshape;
use App\TMsew;
use App\tmordertable; //ตาลเพิ่ม

/**
 * Class DashboardController.
 */
class StockvkController extends Controller
{
    /**
     * @return \Illuminate\View\View
     */
    public function index()
    {
        //dd('datein');
        return view('admin.stockvk.index');


    }

    public function create()
    {
        //dd('Stock2 Create');
        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $ordertable   = tmordertable::all();   //ตาลเพิ่ม
        $sizes = \DB::table('tmsize')->get();
        $season = \DB::table('tmseason')->get();
        $ordertype = \DB::table('tmordertype')->get();

        $orders = [
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'season'       => $season,
            'ordertype'    => $ordertype,
            'ordertable'   => $ordertable    //ตาลเพิ่ม
        ];

        return view('admin.stockvk.create', compact('orders'));
        //return view('admin.scanpackking.create');
    }

    public function edit($id)
    {
        //dd($id);
        abort_unless(\Gate::allows('order_create'), 403);
        $customer     = TMcustomer::all();
        $foruse       = TMforuse::all();
        $forms        = TMgenerate::all();
        $shape        = TMshape::all();
        $sews         = TMsew::all();
        $totalsews    = TMtotalsew::all();
        $blenchs      = TMblench::all();
        $ordertable   = tmordertable::all();   //ตาลเพิ่ม
        $sizes = \DB::table('tmsize')->get();
        $season = \DB::table('tmseason')->get();
        $ordertype = \DB::table('tmordertype')->get();

        $data = DB::table('torder_stockvk')->where('XIStVkID','=',$id)->first();
        // dd($data);
        $order = [
            'data'     => $data,
            'customer'     => $customer,
            'foruse'       => $foruse,
            'forms'        => $forms,
            'shape'        => $shape,
            'sews'         => $sews,
            'totalsews'    => $totalsews,
            'blenchs'      => $blenchs,
            'sizes'        => $sizes,
            'season'       => $season,
            'ordertype'    => $ordertype,
            'ordertable'   => $ordertable    //ตาลเพิ่ม
        ];

        //dd($data);
        return view('admin.stockvk.edit',
            ['data' => $data],
            ['order'=>$order]);

    }

    public function update(Request $request,$id){
        // dd($request);
        DB::beginTransaction();
        try {
                DB::table('torder_stockvk') ->where('XIStVkID','=',$id)
                ->update(
                    [
                        'XVOrderIn'          => $request->XVOrderIn,
                        // 'XVStVkSize'         => $request->XVStVkSize,
                        'XVStVkColor'        => $request->XVStVkColor,
                        'XIStVkNum'          => $request->XIStVkNum,
                        'XFStVkCost'         => $request->XFStVkCost,
                        'XFStVkPrice'        => $request->XFStVkPrice,
                        // 'XVStVkSKUin'        => $request->XVStVkSKUin,
                        // 'XVStVkSKUout'      => $request->XVStVkSKUout,
                        'XISeasonCode'      => $request->XISeasonCode,
                        'XIForCode'         => $request->XIForCode,
                        'XIGenerateCode'     => $request->XIGenerateCode,
                        'XIShapeCode'      => $request->XIShapeCode,
                        'XIStVkSta'         => 'OH',

                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                abort(500, 'Internal error');
            }
            return redirect('admin/stockvk')->with('message','บันทึกสำเร็จ');


    }

    public function store(Request $request)
    {
        // dd($request->all());
        $tmp = $request->XVOrderIn.$request->XVStVkSize;
        // dd($tmp);
        DB::beginTransaction();
        try {
                DB::table('torder_stockvk')->insert(
                    [
                        'XVOrderIn'          => $request->XVOrderIn,
                        // 'XVStVkSize'         => $request->XVStVkSize,
                        'XVStVkColor'        => $request->XVStVkColor,
                        'XIStVkNum'          => $request->XIStVkNum,
                        'XFStVkCost'         => $request->XFStVkCost,
                        'XFStVkPrice'        => $request->XFStVkPrice,
                        // 'XVStVkSKUin'        => $request->XVStVkSKUin,
                        // 'XVStVkSKUout'      => $request->XVStVkSKUout,
                        'XISeasonCode'      => $request->XISeasonCode,
                        'XIForCode'         => $request->XIForCode,
                        'XIGenerateCode'     => $request->XIGenerateCode,
                        'XIShapeCode'      => $request->XIShapeCode,
                        'XIStVkSta'         => 'OH',
                    ]
                );
            DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                //dd($e->getMessage());
                abort(500, 'Internal error');
            }

            // try {
            //     DB::table('torder_inout')->insert(
            //         [
            //             'XDIODate'          => DB::Raw('now()'),
            //             'XVOrderMItemNo'    => $request->XVStVkSKUout,
            //             'XVOrderIn'         => $request->XVOrderIn,
            //             'XVStVkSize'        => $request->XVStVkSize,
            //             'XVIOSKUin'         => $request->XVStVkSKUin,
            //             'XIIONum'           => $request->XIStVkNum,
            //             'XIIOSta'           => "99",
            //             'XIIOinorout'       => "1",
            //             'XTWhenCreate'      => DB::Raw('now()'),
            //             'XTWhenEdit'        => DB::Raw('now()'),
            //             'XVWhoCreate'       => Auth::user()->name,
            //             'XVWhoEdit'         => Auth::user()->name,
            //         ]
            //     );
            // // DB::commit();

            // } catch (\Exception $e) {
            //     echo $e;
            //     // DB::rollBack();
            //     abort(500, 'Internal error');
            // }



            return redirect('admin/stockvk')->with('message','บันทึกสำเร็จ');
        //return view('admin.scanpackking.create');
    }

    public function getdata()
    {
        //dd("testvk");
        $sql="select * from torder_stockvk order by XIStVkID desc";
        $data = \DB::select($sql);
        $data = array(
            'data' => $data,
        );

        print json_encode($data);
    }

    public function dele($id)
    {
        //($id);
        $data = DB::table('torder_stockvk')->where('XIStVkID','=',$id)->delete();
        return view('admin.stockvk.index');
    }


}
