<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\GennarateidController;
use App\Http\Requests\MassDestroyTotalsewinglocatinRequest;
use App\Http\Requests\StoreTotalsewinglocatinRequest;
use App\Http\Requests\UpdateTotalsewinglocatinRequest;
use App\TMtotalsew;

use Illuminate\Support\Facades\Auth;

class TotalsewinglocatinController extends Controller
{
    public function index()
    {

        abort_unless(\Gate::allows('totalsew_access'), 403);

        $totalsews = TMtotalsew::all();

        return view('admin.totalsewinglocatin.index', compact('totalsews'));
    }

    public function create()
    {
        abort_unless(\Gate::allows('totalsew_create'), 403);

        return view('admin.totalsewinglocatin.create');
    }

    public function store(StoreTotalsewinglocatinRequest $request)
    {

        abort_unless(\Gate::allows('totalsew_create'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $request->request->add(['XVWhoCreate' => Auth::user()->name]);
        $totalsewinglocatin = TMtotalsew::create($request->all());

        return redirect()->route('admin.totalsewinglocatin.index');
    }

    public function edit(TMtotalsew $totalsewinglocatin)
    {

        abort_unless(\Gate::allows('totalsew_edit'), 403);

        return view('admin.totalsewinglocatin.edit', compact('totalsewinglocatin'));
    }

    public function update(UpdateTotalsewinglocatinRequest $request, TMtotalsew $totalsewinglocatin)
    {

        abort_unless(\Gate::allows('totalsew_edit'), 403);

        //add request
        $request->request->add(['XVWhoEdit' => Auth::user()->name]);
        $totalsewinglocatin->update($request->all());

        return redirect()->route('admin.totalsewinglocatin.index');
    }

    public function show(TMtotalsew $totalsewinglocatin)
    {
        abort_unless(\Gate::allows('totalsew_show'), 403);

        return view('admin.totalsewinglocatin.show', compact('totalsewinglocatin'));
    }

    public function destroy(TMtotalsew $totalsewinglocatin)
    {
        abort_unless(\Gate::allows('totalsew_delete'), 403);


        $totalsewinglocatin->delete();

        return back();
    }

    public function massDestroy(MassDestroyTotalsewinglocatinRequest $request)
    {

        abort_unless(\Gate::allows('totalsew_delete'), 403);

        //add request
        TMtotalsew::whereIn('XITotalSewCode', request('ids'))->delete();

        return response(null, 204);
    }
}
