<?php

namespace App\Http\Requests;

use App\TMaccgroup;
use Gate;
use Illuminate\Foundation\Http\FormRequest;

class MassDestroyAccGroupRequest extends FormRequest
{
    public function authorize()
    {
        return abort_if(Gate::denies('accgroup_delete'), 403, '403 Forbidden') ?? true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:tmaccgroup,XIAccGroupCode',
        ];
    }
}
