<?php

namespace App\Http\Requests;

use App\TMblench;
use Gate;
use Illuminate\Foundation\Http\FormRequest;

class MassDestroyBlenchRequest extends FormRequest
{
    public function authorize()
    {
        return abort_if(Gate::denies('blench_delete'), 403, '403 Forbidden') ?? true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:TMblench,XIBlenchCode',
        ];
    }
}
