<?php

namespace App\Http\Requests;

use App\TMshape;
use Gate;
use Illuminate\Foundation\Http\FormRequest;

class MassDestroyShapeRequest extends FormRequest
{

    public function authorize()
    {
        return abort_if(Gate::denies('shape_delete'), 403, '403 Forbidden') ?? true;
    }

    public function rules()
    {
      return [
          'ids'   => 'required|array',
          'ids.*' => 'exists:TMshape,XIShapeCode',
      ];
    }
}
