<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Tdocprexp extends Model
{
    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'TMdocprexp';
    protected $primaryKey = 'Docid';

    protected $fillable = [
        'Docid', 'Doctype', 'Prefix', 'Lvalue'
    ];

    protected $casts = ['Lvalue' => 'bigint'];

    protected static function updatedocid($Docid, $Lvalue)
    { 
        return DB::table('TMdocprexp')
            ->where('Docid', $Docid)
            ->update(['Lvalue' => $Lvalue]);
    }

    protected static function genid($Docid)
    {

        // get year
        $Tmpyear = date("Y");

        if (date("n") < 10) {
            $Tmpmonth = "0" . date("n");
        } else {
            $Tmpmonth = date("n");
        }

        if (date("d") < 10) {
            $Tmpday = "0" . date("d");
        } else {
            $Tmpday = date("d");
        }

        $Tmpsearch = $Tmpyear . $Tmpmonth;

        $Genbill  = DB::SELECT("SELECT IFNULL(MAX(CAST(Lvalue as UNSIGNED INTEGER)), 0) + 1 as Autoid
                                     FROM TMdocprexp
                                     WHERE LEFT(Lvalue, 6) = ? AND Docid = ? ", [$Tmpsearch, $Docid]);
// dd()
        if ($Genbill['0']->Autoid > 0) {
            $Sautoid = $Genbill['0']->Autoid;
        } else {
            $Sautoid = "1";
        }

        if ($Sautoid == 1) {
            $Sautoid = $Tmpsearch . "0001";
        } else {
            $Sautoid = $Sautoid;
        }

        return $Sautoid;
    }

    protected static function getpx($key)
    {
        return DB::table('TMdocprexp')
            ->where('Docid', '=', $key)
            ->get();
    }
}
