@extends('layouts.admin')

@section('title', 'หน้าจอยี่ห้อซิป | เพิ่ม')

@section('content')


  <form action="{{ route("admin.blench.store") }}" method="POST" enctype="multipart/form-data">
      @csrf


    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} {{ trans('global.blench') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVBlenchName') ? 'has-error' : '' }}">
                <label for="XVBlenchName">{{ trans('global.TMblench.fields.XVBlenchName') }}*</label>
                <input type="text" id="XVBlenchName" name="XVBlenchName" class="form-control" maxlength="191" value="{{ old('XVBlenchName', isset($blench) ? $blench->XVBlenchName : '') }}" required autofocus>
                @if($errors->has('XVBlenchName'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVBlenchName') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMblench.fields.XVBlenchName_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.blench.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
