@extends('layouts.admin')

@section('title', env('APP_NAME') . ' |  รายงานตรวจรับการจจัดส่ง')

@section('content')

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header text-white bg-dark">
                    <form action="{{ route("admin.checkdelivery.update", [$datas['XVCarCode']]) }}" method="POST" enctype="multipart/form-data">
                        <div class="row">
                        @csrf
                        @method('PUT')
                        <div class="col">
                        ตรวจรับการจัดส่ง ทะเบียนรถ : {{ $datas['XVCarCode'] }}  || วันที่ : {{ $datas['XDDateInSend'] }}
                            <div class="custom-control custom-checkbox">
                                        <input type="checkbox" name="XCStatusSend" class="custom-control-input" id="defaultUnchecked" checked>
                                        <label class="custom-control-label" for="defaultUnchecked">ยืนยันตรวจรับการจัดส่ง</label>
                                    </div>
                        </div>
                        <div class="col text-right">
                            <input type="hidden" name="XDDateInSend" value="{{ $datas['XDDateInSend']}}">
                            <input class="btn btn-success active" type="submit" value="ยืนยัน ตรวจรับการจัดส่ง">
                        </div>
                        </div>
                        </form>

                    </div><!--card-header-->
                     <div class="card-body">
                            <table  class="table display" id="datatable" style="width:100%">
                                    <thead class="text-white bg-dark ">
                                        <tr >
                                            <th>ลำดับ</th>
                                            <th>เลขที่ Order</th>
                                            <th>เลขที่อ้างอิง Order</th>
                                            <th>เลขที่กล่อง</th>
                                            <th>Size</th>
                                            <th>เลขที่ Barcode</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $row =1;
                                        @endphp
                                        @foreach ($datas['res_bc'] as $res)
                                        <tr>
                                            <td>{{ $row }}</td>
                                            <td>{{ $res->XVOrderDocNo }}</td>
                                            <td>{{ $res->XVOrderMItemNo }}</td>
                                            <td>{{ $res->XVBoxCode }}</td>
                                            <td>{{ $res->XVOrderBSize }}</td>
                                            <td>{{ $res->XVOrderBCode }}</td>
                                        </tr>
                                        @php
                                            $row++;
                                        @endphp
                                        @endforeach


                                    </tbody>
                                </table>
                        </div>
                        <div class="card-footer">
                                <div class="row">
                                    <div class="col">
                                        <a href="{{route('admin.checkdelivery.index')}}" class="btn btn-dark col-lg-2 active" role="button" aria-pressed="true">กลับ</a>
                                    </div>

                                </div>
                                </div>
                </div><!--card-->
            </div><!--col-->
        </div><!--row-->

@endsection

    @section('scripts')
    <script>
          $(function () {
            $('#datatable').DataTable();
          })
    </script>
    @endsection

