@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | รายงานตรวจรับการจัดส่ง')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    รายงานตรวจรับการจัดส่ง
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>ลำดับ</th>
                            <th>วันที่</th>
                            <th>ทะเบียนรถ</th>
                            {{-- <th>รหัส Barcoed กล่อง</th> --}}
                            <th>จำนวนสินค้า</th>
                            <th>รายละเอียด</th>
                            <th>สถานะ</th>
                        </tr>
                        </thead>
                        <tbody>
                            @php
                                $row=1;
                            @endphp
                            @foreach ($datas as $item)
                            <tr>
                                <td>{{ $row++}}</td>
                                <td>{{ $item->XDDateInSend}}</td>
                                <td>{{ $item->XVCarCode}}</td>
                                <td>{{ $item->XICountAll}}</td>
                                <td><a href="{{ url('admin/reportCheckDeliveryDetail').'/'.$item->XVCarCode.'/'.$item->XDDateInSend}}" type='button'  class='btn btn-success'>รายละเอียด</a></td>
                                <td>{{ $item->XCStatusSend}}</td>
                            </tr>
                            @endforeach

                        </tbody>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
       $(document).ready(function() {
            $('#datatable').DataTable({});
        })
    </script>
    @endsection

{{-- group order size --}}
