@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | หน้าจอรายละเอียดตรวจสอบ Order')

@section('content')
    <div class="card">
        <div class="card-header text-white bg-dark">
            รายละเอียดตรวจสอบ Order
        </div>
        <div class="card-body">

            <div class="row">
                <div class="table-responsive">
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead class="thead bg-secondary text-black">
                            <tr class="text-left">
                                <th scope="col">วันที่อนุมัติ</th>
                                <th scope="col">เลขที่เอกสาร</th>
                                <th scope="col">Item No.</th>
                                <th scope="col">Barcode</th>
                                <th scope="col">Size</th>
                                <th scope="col">สถานที่</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($datas as $item)
                            <tr>
                                <td>{{ $item->XDOrderDateApprove}}</td>
                                <td>{{ $item->XVOrderDocNo}}</td>
                                <td>{{ $item->XVOrderMItemNo}}</td>
                                <td>{{ $item->XVOrderBCode}}</td>
                                <td>{{ $item->XVOrderDSize}}</td>
                                <td>{{ $item->XVLocationName}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div><!--end table-->
                <a href="{{ route('admin.checkorder.index') }}" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="กลับ">
                กลับ
                </a>
            </div><!--end row-->
        </div><!--end card body-->
    </div><!--end card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable();
        })
    </script>
    @endsection
