@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | เพิ่ม')

@section('content')

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header text-white bg-dark">
                        นำเข้าข้อมูล ใบกำกับกล่องสินค้า
                    </div><!--card-header-->
                    <div class="card-body">
                        <div class="row d-flex justify-content-center" >
                            <div class="form-group col-lg-10" >
                                <h3 align="center">Import Excel File</h3>
                                <br />
                            @if(count($errors) > 0)
                                <div class="alert alert-danger">
                                Upload Validation Error<br><br>
                                <ul>
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                                </ul>
                                </div>
                            @endif

                            @if($message = Session::get('success'))
                            <div class="alert alert-success alert-block">
                                <button type="button" class="close" data-dismiss="alert">×</button>
                                    <strong>{{ $message }}</strong>
                            </div>
                            @endif
                            <form class="form-horizontal" method="POST" action="{{ url('admin/importexcel/import') }}" enctype="multipart/form-data">
                                {{ csrf_field() }}
                                <div class="form-group">
                                <table class="table">
                                <tr>
                                <td width="40%" align="right"><label>Select File for Upload</label></td>
                                <td width="30">
                                    <input id="select_file" type="file" class="form-control" name="select_file" required>
                                </td>
                                <td width="30%" align="left">
                                    <input type="submit" name="btn_submit" class="btn btn-primary" value="Upload">
                                </td>
                                </tr>
                                <tr>
                                <td width="40%" align="right"></td>
                                <td width="30"><span class="text-muted">.xls, .xslx</span></td>
                                <td width="30%" align="left"></td>
                                </tr>
                                </table>
                                </div>
                            </form>



                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                    <div class="row">
                        <div class="col">
                            <a href="{{route('admin.importexcel.index')}}" class="btn btn-dark col-lg-2 active" role="button" aria-pressed="true">กลับ</a>
                        </div>

                    </div>
                    </div>
                </div><!--card-->
            </div><!--col-->
        </div><!--row-->

@endsection

    @section('scripts')
    <script>
          $(function () {



          })
    </script>
    @endsection
