@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | เพิ่ม')

@section('styles')
<style>
.my-custom-scrollbar {
position: relative;
height: 300px;
overflow: auto;
}
.table-wrapper-scroll-y {
display: block;
}

.table tbody tr > td.success {
  background-color: #dff0d8 !important;
}

.table tbody tr > td.error {
  background-color: red !important;
}

.table tbody tr > td.warning {
  background-color: #fcf8e3 !important;
}

</style>
@endsection

@section('content')

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header text-white bg-dark">
                        Scan สินค้าลงกล่อง
                    </div><!--card-header-->
                    <div class="card-body">
                        <div class="row d-flex " >
                            <div class="form-group col-12" >
                                <div class="form-group col-6" >
                                    <label for="XIUser_id">พนักงาน Pack</label>
                                    <input type="hidden" class="form-control" id="XIUser_id" name="XIUser_id" placeholder="" value="{{ \Auth::user()->id }}">
                                    <input type="text" class="form-control" id="XVUser_name" name="XVUser_name" placeholder="ชื่อพนักงาน" value="{{ \Auth::user()->name }}" readonly>
                                </div>
                                <div class="form-group col-6">
                                    <label for="XVBoxCode">บาร์โค้ดกล่อง</label>
                                    <input type="text" style="margin-top:10px;" name="XVBoxCode" id="XVBoxCode" class="form-control" placeholder="แสกนบาร์โค้ด(กล่อง)" value="{{ $boxno}}" readonly>
                                </div>
                                <div class="form-group col-12">
                                    <label for="XVOrderBCode">สินค้า</label>
                                    <input type="text" style="margin-top:10px;" name="XVOrderBCode" id="XVOrderBCode" class="form-control" placeholder="" value="{{ $desc}}" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="table-wrapper-scroll-y my-custom-scrollbar">
                        <table class="table table-bordered table-striped mb-0" cellspacing="0"  width="100%" id="myTable">
                            <thead class="thead-dark">
                                <tr>
                                {{-- <th scope="col">#</th> --}}
                                <th scope="col">บาร์โค้ดสินค้า</th>
                                <th scope="col">Order No</th>
                                <th scope="col">Item No</th>
                                <th scope="col">Delete</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($datas as $item)
                                <tr id="r{{$item->XVOrderBCode }}" >
                                    <td>{{ $item->XVOrderBCode}}</td>
                                    <td>{{ $item->XVOrderDocNo}}</td>
                                    <td>{{ $item->XVOrderMItemNo}}</td>
                                    <td> <a href="#" name="confirm_item"
                                        data-id="{{ $item->XVOrderBCode}}"
                                        class="btn btn-danger btn_del"
                                        data-toggle="tooltip"
                                        data-placement="top" title="ลบรายการ"
                                      >
                                            <i class="fas fa-trash"></i>
                                        </a>
</td>
                                </tr>
                                @endforeach

                            </tbody>
                            <tbody>


                            </tbody>
                        </table>
                        </div>

                    </div>
                    <div class="card-footer">
                    <div class="row">
                        <div class="col">
                            <a href="{{ url('admin/scanproductinboxCreate/'.$boxno) }}" class="btn btn-dark col-lg-2 active" role="button" aria-pressed="true">กลับ</a>
                        </div>

                    </div>
                    </div>
                </div><!--card-->
            </div><!--col-->
        </div><!--row-->

@endsection

    @section('scripts')
    <script>
          $(function () {
            $(document).ajaxSend(function() {
                $("#overlay").fadeIn(300);　
            });

            if($('#XVBoxCode').val() !=""){
                $('#XVOrderBCode').focus();
            }else{
                $('#XVBoxCode').focus();
            }

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            const Toast = Swal.mixin({
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 1000,
            timerProgressBar: true,
            onOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
            })



            $('.dataTables_length').addClass('bs-select');

            $('.btn_del').click(function(){
                code = $(this).data('id')

                Swal.fire({
                title: 'ยืนยันการยกเลิก ?',
                text: "คุณต้องการยกเลิกรายการเลขที่ "+ code +" ใช่หรือไม่",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'ยืนยัน !',
                cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                if (result.value) {
                    $.ajax({
                        type:'POST',
                        url:'{{url('')}}/admin/scanproductinboxDel',
                        data:{barcode:code,location:9},
                        dataType: 'JSON',
                        success:function(result){
                            if (result.success ==1)
                            $('#r'+code).remove();
                        }
                        }).done(function() {
                            setTimeout(function(){
                                $("#overlay").fadeOut(300);
                            },500);
                        });
                }
                })
            })

          })



    </script>
    @endsection
