@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | รับเข้า Packking')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Scan สินค้าลงกล่อง
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/scanproductinbox/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>เลขที่กล่อง</th>
                            <th>เลขที่ Order</th>
                            <th>เลขที่อ้างอิง Order</th>
                            <th>รหัสสินค้า</th>
                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
       $(document).ready(function() {
            // $('#XVBoxCode').keyup(function(e){
                // console.log($('#XVBoxCode').val().length)
                // if($(this).val().length > 0 && e.keyCode == 13)
                // {
                    $('#datatable').DataTable({
                        "processing": true,
                        "serverSide": true,
                        pageLength: 10,
                        "ajax": {
                            url : "{{url('')}}/admin/scanproductinboxGetData",
                            data:{_token: "{{csrf_token()}}",boxCode:$('#XVBoxCode').val(),location:9} ,
                            dataType: "json",
                            type: "POST",
                            },
                        "columns": [
                            { data: 'XVBoxCode' },
                            { data: 'XVOrderDocNo' },
                            { data: 'XVOrderMItemNo' },
                            { data: 'XVOrderBCode' },
                        ]
                    });
                // }
            // })
        })
    </script>
    @endsection

{{-- group order size --}}
