@extends('layouts.admin')

@section('title', env('APP_NAME') . ' |  Scan รับเข้า Stock RTV')

@section('content')

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header text-white bg-dark">
                        Scan รับเข้า Stock RTV
                    </div><!--card-header-->
                     <div class="card-body">
                        <div class="row">
                            <div class="form-group col-lg-6" style="margin-left:370px">
                                <div class="row">
                                    <label for="" style="margin-top:20px" class="col-lg-6 ">จำนวนที่ Scan: <span id="count_all"></span></label>
                                    <label for="" style="margin-top:20px" class="col-lg-4 text-right ">วันที่: <?php print DATE_FORMAT(NOW(),'d/m/Y')?></label>
                                </div>
                                <img width="512px"  src="{{url('')}}/img/barcode.jpg" alt="">
                                <input type="text" style="margin-top:10px;width:509px " name="XVOrderBCode" id="XVOrderBCode" class="text-center" placeholder="แสกนบาร์โค้ด">
                                <div class="row">
                                    <label for="" style="margin-top:20px" class="col-lg-6 ">Order NO: <span id="order_no"></span></label>
                                    <label for="" style="margin-top:20px" class="col-lg-4 text-right">Size: <span id="size"></span></label>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer">
                    <div class="row">
                        <div class="col">
                            <a href="{{route('admin.scanstockrtv.index')}}" class="btn btn-dark col-lg-2 active" role="button" aria-pressed="true">กลับ</a>
                        </div>

                    </div>
                    </div>
                </div><!--card-->
            </div><!--col-->
        </div><!--row-->

@endsection

    @section('scripts')
    <script>
          $(function () {
            $('#XVOrderBCode').focus();
              $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

            const Toast = Swal.mixin({
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 1000,
            timerProgressBar: true,
            onOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
            })


            var count_scan = 0;
            $('#XVOrderBCode').keyup(function(e){
            if(e.keyCode == 13)
            {
                $this = $(this);
                if ($this.val().length != 18){

                    Swal.fire({
                    title: 'Oops....',
                    text: "เลขบาร์โค้ดไม่ถูกต้องกรุณาตรวจสอบ!",
                    icon: 'warning',
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'OK'
                    }).then((result) => {
                        if (result.value) {
                                            return false;
                        }
                    })
                }else{

                    console.log('{{url('')}}/admin/scanforbleachingjobsupdate')
                     $.ajax({
                        type:'POST',
                        url:'{{url('')}}/admin/scanforbleachingjobsupdate',
                        data:{barcode: $this.val(),location:3},
                        dataType: 'JSON',
                        success:function(data){
                            console.log(data)
                            if(data.success =="0"){
                                Swal.fire({
                                title: 'Oops....',
                                text: "ไม่พบข้อมูลในระบบกรุณาตรวจสอบ !",
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.value) {
                                    $('#order_no').html("")
                                    $('#size').html("")
                                }
                                })
                            }else if(data.success == "2"){

                                Swal.fire({
                                title: 'Oops....',
                                text: "Scan ซ้ำมีข้อมูลแล้ว",
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                    $('#order_no').html("")
                                    $('#size').html("")
                                    $this.val('')
                                        return false;

                                })
                            }
                            else{
                                Toast.fire({
                                icon: 'success',
                                title: 'Scan สำเร็จ'

                                })

                                count_scan++
                                $('#count_all').html(count_scan)
                                $('#order_no').html(data.order_no)
                                $('#size').html(data.size)
                                $this.val('')

                            }
                        }
                        });
                }





            }
        });


          })
    </script>
    @endsection

