@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | หน้าจอลูกค้า')

@section('content')

<div class="card">

  <div class="card-header">
      รายการที่ Import File
  </div>

    <div class="card-body">
        <div class="row">

            <div class="col-sm-12 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ route('admin.sendimportfile.create') }}" class="btn btn-success ml-1 active" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i> เพิ่มข้อมูล</a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table  class="table table-bordered table-striped table-hover datatable">
                        <thead>
                            <tr>
                                {{-- <th width="10"></th> --}}
                                {{-- <th width="15%">{{ trans('global.Torder_hd.fields.XVOrderDocNo') }}</th> --}}
                                {{-- <th>วันที่อนุมัติ</th> --}}
                                <th>วันที่นำเข้า</th>
                                <th>เลขที่ PO</th>
                                <th>รหัสสาขา</th>
                                <th style="text-align:center"  width="15%">{{ trans('global.manage') }}</th>
                            </tr>
                        </thead>
                        <tbody>

                          @foreach ($order['roles'] as $key =>$roles)
                              <tr data-entry-id="{{ $roles->XVPO_Nbr }}">
                                  <td>
                                      {{ $roles->XVDateIn ?? '' }}
                                  </td>
                                  <td>
                                      {{ $roles->XVPO_Nbr ?? '' }}
                                  </td>
                                  <td>
                                      {{ $roles->XVStore_Nbr ?? '' }}
                                  </td>
                                  {{-- <td style="text-align:center" >
                                      <div class="btn-group" role="group" >
                                        @can('order_edit')
                                            <a href="{{ route('admin.sendimportfile.edit', $roles->XVPO_Nbr) }}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endcan
                                      </div>

                                  </td> --}}

                              </tr>
                          @endforeach


                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
{{-- {{ route('admin.order.massDestroy') }} --}}
    @section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script>
          $(function () {


              $('.datatable:not(.ajaxTable)').DataTable({
                  "pageLength": 25
              })

            $('.btn_del').click(function(){
                var $this  =$(this);

                if ($this.data('status') !="1"){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'ไม่สามารถยกเลิกรายการเลขที่ '+ $this.data('id') +' ได้ !'
                    })

                    return false;
                }

                Swal.fire({
                title: 'ยืนยันการยกเลิก ?',
                text: "คุณต้องการยกเลิกรายการเลขที่ "+ $this.data('id') +" ใช่หรือไม่ !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
                confirmButtonText: 'ยืนยัน !',
                cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                if (result.value) {
                    $('#frm').attr('action','{{ url('admin/order/del') }}'+'/'+$this.data('id') )
                    $('#frm').submit();
                }
                })
            })
          })
    </script>
    @endsection

@endsection
