@extends('layouts.admin')

@section('title',env('APP_NAME') . 'ใบกำกับกล่องสินค้า')

@section('content')
    <div class="card">
        <div class="card-header text-white bg-dark">
            ใบกำกับกล่องสินค้า
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col text-right">
                    <button type="button" class="btn btn-secondary ml-1 col-1">บันทึก</button>
                    <a class="btn btn-secondary ml-1 col-1" href="#" role="button">แก้ไข</a>
                    <a class="btn btn-secondary ml-1 col-1" href="#" role="button">พิมพ์</a>
                </div>
            </div><!--end row-->

            <hr>

            <div class="form-row">
                <div class="form-group col-md-4">

                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่จ่ายอุปกรณ์/</label>
                    <div class="end_date input-group mb-4">
                        <input class="form-control end_date" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderDocMDate" id="eratedate_datepicker"
                         value="<?php print DATE_FORMAT(NOW(),'d/m/Y')?>"
                         required="required">
                        <div class="input-group-append">
                          <span class="fa fa-calendar input-group-text end_date_calendar" aria-hidden="true "></span>
                        </div>
                      </div>
                </div>
                <div class="form-group col-md-3">
                    <label for="text" class="col-md-8 form-control-label">เลือกแผนกที่จ่ายอุปกรณ์</label>
                            <select id="XIAddBlenchCode" name="XIAddBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                                @foreach ($payequipmentm['branch'] as $branch)
                                <option value="{{ $branch->XIBranchCode }}" >{{ $branch->XVBranchName }} </option>
                              @endforeach
                                </select>
                                {{-- {{ old('XIBranchCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }} --}}
                </div><!--form group row-->
                <div class="form-group col-md-3">
                    <label for="text" class="col-md-12 form-control-label">ผู้จ่ายอุปกรณ์</label>
                    <div class="form-group col-6" >
                        <input type="hidden" class="form-control" id="XIUser_id" name="XIUser_id" placeholder="" value="{{ \Auth::user()->id }}">
                        <input type="text" class="form-control" id="XVUser_name" name="XVUser_name" placeholder="ชื่อพนักงาน" value="{{ \Auth::user()->name }}" readonly>
                    </div>
                </div><!--form group row-->
            </div><!--end form row-->

            <hr>

            <div class="form-row">
                <div class="form-group col-md-4">

                </div>
                <div class="form-group col-md-2">
                    <label for="text">เลขที่เอกสาร</label>
                    <input type="text" name="XVOrderDocNo" class="form-control text-center" id="" value="{{ old('XVOrderDocNo', isset($payequipmentm) ? $payequipmentm['XVOrderDocNo'] : 'Autoid') }}" readonly >
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่สร้าง Order</label>
                    <input type="text" name="XDOrderDocMDate" class="form-control text-center" id="text" value="{{ old('XDOrderDocMDate', isset($payequipmentm['order_hd']) ? $payequipmentm['order_hd']->XDOrderDocMDate : '') }}" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่อนุมัติ</label>
                    <input class="form-control end_date text-center" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderDateApprove"
                       value="{{ old('XDOrderDateApprove', isset($payequipmentm['order_hd']->XDOrderDateApprove) ? DATE_FORMAT(new DateTime($payequipmentm['order_hd']->XDOrderDateApprove),'d/m/Y') : DATE_FORMAT(NOW(),'d/m/Y')) }}"
                       required="required" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">item No:</label><sub class="text-danger">&nbsp;&nbsp;&nbsp;*</sub>
                    <input type="text" class="form-control text-center"  name="XVOrderMItemNo" id="XVOrderMItemNo" value="{{ old('XVOrderMItemNo', isset($payequipmentm['order_hd']) ? $payequipmentm['order_hd']->XVOrderMItemNo : '') }}"  required>
                </div>
            </div><!--end form row-->

            <div class="form-row">
                <div class="form-group col-md-2">
                    <label for="text">Season:</label>
                    <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderMSeasion" id="XVOrderMSeasion" value="{{ old('XVOrderMSeasion', isset($payequipmentm['order_hd']) ? $payequipmentm['order_hd']->XVOrderMSeasion : '') }}"   placeholder="Season" style="font-size: 16px;">
                </div>
                <div class="form-group col-md-2">
                    <label for="text">ลูกค้า</label>
                   <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($payequipmentm['customer'] as $customer)
                          <option value="{{ $customer->XIGuestCode }}" {{ old('XIGuestCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XIGuestCode == $customer->XIGuestCode) ? 'selected' : '') }}>{{ $customer->XVGuestName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">สำหรับ/</label>
                    <select id="XIForCode" name="XIForCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($payequipmentm['foruse'] as $foruse)
                        <option value="{{ $foruse->XIForCode }}" {{ old('XIForCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XIForCode == $foruse->XIForCode) ? 'selected' : '') }}>{{ $foruse->XVForType }} </option>
                      @endforeach
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="text">แบบงาน</label>
                    <select id="XIGenerateCode" name="XIGenerateCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($payequipmentm['forms'] as $forms)
                          <option value="{{ $forms->XIGenerateCode }}" {{ old('XIGenerateCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XIGenerateCode == $forms->XIGenerateCode) ? 'selected' : '') }}>{{ $forms->XVGenerateName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="text">ทรง</label>
                    <select id="XIShapeCode" name="XIShapeCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($payequipmentm['shape'] as $shape)
                        <option value="{{ $shape->XIShapeCode }}" {{ old('XIShapeCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XIShapeCode == $shape->XIShapeCode) ? 'selected' : '') }}>{{ $shape->XVShapeName }} </option>
                      @endforeach
                    </select>
                </div>

                <div class="col-lg-12">
                    <div class="card-body text-center">
                            @php
                                $sum_order =0;
                                $sum_per =0;
                                $sum_total =0;
                            @endphp
                            <table class="table table-bordered " >
                                <thead class="text-white bg-dark">
                                    <tr>
                                        <th scope="col">Size</th>
                                         @foreach ($payequipmentm['order_dt'] as $key =>$order_dt)
                                            <td>{{ old('XVOrderDSize', isset($order_dt) ? $order_dt['XVOrderDSize'] : '') }}</td>
                                        @endforeach
                                        <th scope="col" style="width:150px">Total</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td scope="row">ออเดอร์ไทย</td>
                                        @foreach ($payequipmentm['order_dt'] as $key =>$order_dt)
                                        @php
                                            $sum_order +=$order_dt['XIOrderDNum'];
                                        @endphp
                                            <td>{{ old('XIOrderDNum', isset($order_dt) ? $order_dt['XIOrderDNum'] : '') }}</td>
                                        @endforeach
                                            <td>{{ number_format($sum_order)}}</td>
                                    </tr>
                                    <tr>
                                        <td scope="row">ตัดเพื่อ 5%</td>
                                        @foreach ($payequipmentm['order_dt'] as $key =>$order_dt)
                                        @php
                                            $sum_per +=$order_dt['XIOrderDNum5P'];
                                        @endphp
                                            <td>{{ old('XIOrderDNum5P', isset($order_dt) ? $order_dt['XIOrderDNum5P'] : '') }}</td>
                                        @endforeach
                                            <td>{{ number_format($sum_per)}}</td>
                                    </tr>
                                    <tr>
                                        <td scope="row">รวม</td>
                                        @foreach ($payequipmentm['order_dt'] as $key =>$order_dt)
                                            <td>{{ old('XIOrderDTotalNum', isset($order_dt) ? $order_dt['XIOrderDTotalNum'] : '') }}</td>
                                        @endforeach

                                            <td>{{ number_format($sum_order + $sum_per)}}</td>

                                    </tr>

                                </tbody>
                            </table>
                        </div><!--card body-->
                </div><!--div-->

                <div  class="row">
                    <div class="form-group col-md-4">
                        <label for="text">สถานที่เย็บ หน้าหลัง</label>
                        <select id="XISewCode" name="XISewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                            @foreach ($payequipmentm['sews'] as $sews)
                              <option value="{{ $sews->XISewCode }}" {{ old('XISewCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XISewCode == $sews->XISewCode) ? 'selected' : '') }}>{{ $sews->XVSewName }} </option>
                            @endforeach
                          </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="text">สถานที่เย็บ รวมตัว</label>
                         <select id="XITotalSewCode" name="XITotalSewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                          @foreach ($payequipmentm['totalsews'] as $totalsews)
                            <option value="{{ $totalsews->XITotalSewCode }}" {{ old('XITotalSewCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XITotalSewCode == $totalsews->XITotalSewCode) ? 'selected' : '') }}>{{ $totalsews->XVTotalSewName }} </option>
                          @endforeach
                        </select>
                    </div>
                    <div class="form-group col-md-4">
                        <label for="text" >สถานที่เย็บ ฟอก</label>
                        <select id="XIAddBlenchCode" name="XIAddBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                            @foreach ($payequipmentm['blenchs'] as $blenchs)
                              <option value="{{ $blenchs->XIBlenchCode }}" {{ old('XIBlenchCode', (isset($payequipmentm['order_hd']) && $payequipmentm['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }}>{{ $blenchs->XVBlenchName }} </option>
                            @endforeach
                          </select>
                    </div>
                </div>

            <div class="col-lg-12" >
                <div class="card ">
                    <div class="card-header text-white bg-dark">
                        รายการอุปกรณ์
                    </div>
                    <div class="card-body ">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover datatable ">
                                <thead class="text-white bg-dark">
                                    <tr>
                                        <th scope="col" style="width:60px">รหัส</th>
                                        <th scope="col" style="width:150px">ชื่อ</th>
                                        <th scope="col">รายละเอียด</th>
                                        <th scope="col" style="width:50px">ใช้กับ</th>
                                        <th scope="col"  style="width:60px">จำนวน</th>
                                        <th scope="col "style="width:90px">ราคา/หน่วย</th>
                                        <th scope="col" style="width:80px">รวม</th>
                                        <th scope="col">เเผนกที่เบิก</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach($payequipmentm['tacc'] as $key => $tacc)
                                    <tr >

                                        <td>
                                            {{ $tacc->XVAccesCode ?? '' }}
                                        </td>
                                        <td>
                                            {{ $tacc->XVAccesName ?? '' }}
                                        </td>
                                        <td>
                                            {{ $tacc->XVAccesDesc ?? '' }}
                                        </td>
                                        <td>
                                            {{ $tacc->XVAccesName ?? '' }}
                                        </td>
                                        <td>
                                            {{ $tacc->XIAccesNum ?? '' }}
                                        </td>
                                        <td>
                                            {{ $tacc->XDPriceUnit ?? '' }}
                                        </td>
                                        <td>
                                            {{ $tacc->XIAccesNum ?? '' }}
                                        </td>

                                        <td style="text-align:center" >

                                        </td>

                                    </tr>
                                @endforeach


                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="col">
                                  <a href="{{route('admin.payequipmentm.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
                                </div>

                                <div class="col text-right">
                                  <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
                                </div>
                            </div>
                        </div>

                    </div>
                </div><!--card-->
            </div><br><!--card-->

        </div><!--end card body-->
    </div><!--end card-->
    @section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script>
          $(function () {


              $('.datatable:not(.ajaxTable)').DataTable({
                  "pageLength": 25
              })

            $('.btn_del').click(function(){
                var $this  =$(this);

                if ($this.data('status') !="1"){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'ไม่สามารถยกเลิกรายการเลขที่ '+ $this.data('id') +' ได้ !'
                    })

                    return false;
                }

                Swal.fire({
                title: 'ยืนยันการยกเลิก ?',
                text: "คุณต้องการยกเลิกรายการเลขที่ "+ $this.data('id') +" ใช่หรือไม่ !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'ยืนยัน !',
                cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                if (result.value) {
                    $('#frm').attr('action','{{ url('admin/order/del') }}'+'/'+$this.data('id') )
                    $('#frm').submit();
                }
                })
            })
          })
    </script>
    @endsection
@endsection
