@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | ใบกำกับกล่องสินค้า')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                   ใบกำกับกล่องสินค้า
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table table-bordered table-striped table-hover datatable">
                        <thead>
                        <tr>
                            <th>รหัสสาขา</th>
                            <th>ใบสั่งซื้อ</th>
                            <th>บาร์โค้ดกำกับกล่อง</th>
                            <th>จัดการ</th>
                        </tr>
                        </thead>
                        <tbody>

                            @foreach($data['box'] as $key => $box)
                            <tr >
 <td>
                                    {{ $box->XVStoreNbr ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XVPONbr ?? '' }}
                                </td>

                                <td>
                                    {{ $box->XVBoxCode ?? '' }}
                                </td>


                                <td style="text-align:center" >
                                    @can('order_edit')
                                  <a href="{{ url('admin/shippingmark/create').'/'.$box->XVPONbr.'/'.$box->XVStoreNbr }}"><button type="button" class="btn btn-primary">รายละเอียด</button></a>
                                  @endcan
                                </td>
                            </tr>
                        @endforeach

                        </tbody>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script>
      $(function () {


          $('.datatable:not(.ajaxTable)').DataTable({
              "pageLength": 25
          })
      })
</script>
@endsection


