@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('global.user.title_singular') }}
    </div>

    <div class="card-body">
        <form action="{{ route("admin.users.store") }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group {{ $errors->has('name') ? 'has-error' : '' }}">
                <label for="name">{{ trans('global.user.fields.name') }}*</label>
                <input type="text" id="name" name="name" class="form-control" value="{{ old('name', isset($user) ? $user->name : '') }}" required>
                @if($errors->has('name'))
                    <em class="invalid-feedback">
                        {{ $errors->first('name') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.user.fields.name_helper') }}
                </p>
            </div>
            <div class="form-group {{ $errors->has('XVEmpCode') ? 'has-error' : '' }}">
                <label for="XVEmpCode">รหัสพนักงาน *</label>
                <input type="text" id="XVEmpCode" name="XVEmpCode" class="form-control" value="{{ old('XVEmpCode', isset($user) ? $user->XVEmpCode : '') }}" required>
                @if($errors->has('XVEmpCode'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVEmpCode') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.user.fields.XVEmpCode_helper') }}
                </p>
            </div>
            <div class="form-group {{ $errors->has('XVCardID') ? 'has-error' : '' }}">
                <label for="XVCardID">เลขที่บัตรประชาชน *</label>
                <input type="text" id="XVCardID" name="XVCardID" class="form-control" value="{{ old('XVCardID', isset($user) ? $user->XVCardID : '') }}" required>
                @if($errors->has('XVCardID'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVCardID') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.user.fields.name_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('email') ? 'has-error' : '' }}">
                <label for="email">{{ trans('global.user.fields.email') }}*</label>
                <input type="email" id="email" name="email" class="form-control" value="{{ old('email', isset($user) ? $user->email : '') }}" required>
                @if($errors->has('email'))
                    <em class="invalid-feedback">
                        {{ $errors->first('email') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.user.fields.email_helper') }}
                </p>
            </div>
            <div class="form-group {{ $errors->has('password') ? 'has-error' : '' }}">
                <label for="password">{{ trans('global.user.fields.password') }}</label>
                <input type="password" id="password" name="password" class="form-control" required>
                @if($errors->has('password'))
                    <em class="invalid-feedback">
                        {{ $errors->first('password') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.user.fields.password_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XIBranchCode') ? 'has-error' : '' }}">
                <label for="XIBranchCode">สังกัดแผนก *</label>

                <select name="XIBranchCode" id="XIBranchCode" class="form-control" required>
                    <option value="">-- Select --</option>
                    @foreach($branchs as $branch)
                        <option value="{{ $branch->XIBranchCode }}">
                            {{ $branch->XVBranchName }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="form-group {{ $errors->has('roles') ? 'has-error' : '' }}">
                <label for="roles">{{ trans('global.user.fields.roles') }}*
                    <span class="btn btn-info btn-xs select-all">Select all</span>
                    <span class="btn btn-info btn-xs deselect-all">Deselect all</span></label>
                <select name="roles[]" id="roles" class="form-control select2" multiple="multiple" required>
                    @foreach($roles as $id => $roles)
                        <option value="{{ $id }}" {{ (in_array($id, old('roles', [])) || isset($user) && $user->roles->contains($id)) ? 'selected' : '' }}>
                            {{ $roles }}
                        </option>
                    @endforeach
                </select>
                @if($errors->has('roles'))
                    <em class="invalid-feedback">
                        {{ $errors->first('roles') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.user.fields.roles_helper') }}
                </p>
            </div>
            <div>
                <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
            </div>
        </form>
    </div>
</div>

@endsection
