@extends('layouts.admin')
@section('style')
@section('content')

<div class="card">
    <div class="card-header text-white bg-dark">
        รายละเอียดสินค้า
    </div>
    <div class="card-body">
        <div class="row">
            <div class="form-group col-md-3">
                <label for="text">เลขที่ Barcode :</label>

                <input type="text" class="form-control" id="XVOrderBCode" placeholder="แสกนบาร์โค้ด">
            </div>

            <div class="form-group col-md-3">
                <label for="XVOrderBLocation">ใครยืม</label>
                <select disabled class="form-control" name="XVOrderBLocation" id="XVOrderBLocation">
                    <option>สถานที่</option>
                    <option value="1">Plaining</option>
                    <option value="2">โรงเย็บ</option>
                    <option value="5">FG</option>
                    <option value="6">QC</option>
                    <option value="13">Packing</option>
                    <option value="14">ลูกค้า</option>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label for="text">หมายเหตุการยืม:</label>
                <input disabled type="text" name="XVComment" class="form-control" value="" required id="XVComment">
            </div>
            <div class="col" style="margin-top:30px">
                {{-- <a href="#" class="btn btn-success active ml-1 col-2" role="button">ค้นหา</a> --}}
            </div>

        </div>
        <div class="row">
            <div class="col" style="margin-top:30px">
                <a href="#" class="btn btn-danger active ml-1 col-1" role="button"  id="btnCancel">ยกเลิก</a>
            </div>
        </div>
    </div><!--end card body-->
</div><!--end card-->

@endsection
@section('scripts')
<script>
    $(function () {
        $('#XVOrderBCode').focus();
        $("#XVOrderBCode").attr("disabled", false);

        $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
        });

        const Toast = Swal.mixin({
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 1000,
            timerProgressBar: true,
            onOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        })

        //var count_scan = 0;
        $('#XVOrderBCode').keyup(function(e){
                if(e.keyCode == 13)
                {
                    $this = $(this);
                    if ($this.val().length != 18){

                        Swal.fire({
                        title: 'Oops....',
                        text: "เลขบาร์โค้ดไม่ถูกต้องกรุณาตรวจสอบ!",
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.value) {
                                                return false;
                            }
                        })
                    }else{

                     // console.log('{{url('')}}/admin/editsizebarcodeCheck')
                     $.ajax({
                        type:'POST',
                        url:'{{url('')}}/admin/borrow/checkbarcode',
                        data:{barcode: $this.val()},
                        dataType: 'JSON',
                        success:function(data){
                            console.log(XVComment)
                            if(data.success =="0"){
                                Swal.fire({
                                title: 'Oops....',
                                text: "ไม่พบข้อมูลในระบบกรุณาตรวจสอบ !",
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.value) {
                                    $('#XVOrderBCode').val("")
                                }
                                })
                            }else if(data.success == "1"){
                                $("#XVOrderBCode").attr("disabled", true);
                                $("#XVComment").val(data.XVComment);
                                $('#XVOrderBLocation option[value='+data.XVOrderBLocation+']').prop('selected',true);
                            }
                        }
                        });
                    }
                }
            });



        $('#btnCancel').click(function(e){
            $("#XVOrderBCode").attr("disabled", false);
            $('#XVOrderBCode').val("");
            $('#XVComment').val("");
            $('#XVOrderBCode').focus();
            $('#XVOrderBLocation option:first').prop('selected',true);
            // $("#XVOrderBLocation").attr("disabled", true);
        });

        });
</script>
    @parent
@endsection
