@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รายการที่ตัด ตามโต๊ะตัด
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/cutcloth/inputcut') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
                    {{-- <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/qcin/report') }}" class="btn btn-info ml-2" data-toggle="tooltip" title="พิมพ์"><i class="fas fa-print"></i></a>
                    </div> --}}
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable">
                            <thead>
                            <tr>
                                <th style="width:80px">เลขที่สั่งผลิต</th>
                                <th style="width:40px">โต๊ะที่</th>
                                <th style="width:120px">Item Number</th>
                                <th style="width:30px">27</th>
                                <th style="width:30px">28</th>
                                <th style="width:30px">29</th>
                                <th style="width:30px">30</th>
                                <th style="width:30px">32</th>
                                <th style="width:30px">34</th>
                                <th style="width:30px">36</th>
                                <th style="width:30px">38</th>
                                <th style="width:30px">S</th>
                                <th style="width:30px">M</th>
                                <th style="width:30px">L</th>
                                <th style="width:30px">XL</th>
                                <th style="width:30px">Total</th>
                                <th style="width:100px">ช่าง</th>
                                <th style="width:50px">Option</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                "scrollX" : true,
                pageLength: 25,
                "ajax": {
                    url : "{{url('')}}/admin/cutclothgetdata",
                    data:{location:5} ,
                },
                "columnDefs": [
                    {
                        "targets": 0, // เลขที่
                        "className": "text-center",
                    },
                    {
                        "targets": 1, // วันที่
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // SKU
                        "className": "text-center",
                    },
                    {
                        "targets": 3, // Item Number
                        "className": "text-right",
                    },
                    {
                        "targets": 4, // Size
                        "className": "text-right",
                    },
                    {
                        "targets": 5, // จำนวน
                        "className": "text-right",
                    },
                    {
                        "targets": 6, // แก้ไข
                        "className": "text-right",
                    },
                    {
                        "targets": 7, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 8, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 9, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 10, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 11, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 12, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 13, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 14, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 15, // ลบ
                        "className": "text-right",
                    },
                    {
                        "targets": 16, // ลบ
                        "className": "text-left",
                    },
                    {
                        "targets": 17, // ลบ
                        "className": "text-center",
                    },
                ],
                "columns": [
                    { data: 'XVOrderDocNo2'},
                    { data: 'TableCut'},
                    { data: 'XVOrderIn'},
                    { data: 's27'},
                    { data: 's28'},
                    { data: 's29'},
                    { data: 's30'},
                    { data: 's32'},
                    { data: 's34'},
                    { data: 's36'},
                    { data: 's38'},
                    { data: 'ss'},
                    { data: 'sm'},
                    { data: 'sl'},
                    { data: 'sxl'},
                    { data: 'stotal'},
                    { data: 'XVOinoutNote'},
                    {
                        render: function (data, type, full, meta ) {
                            console.log(full);

                            return ' <a href="{{url('admin/cutcloth/showd')}}/'+full.XVOrderDocNo2+'/'+full.TableCut+'/'+full.XVOrderIn+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                        }
                    },
                ],
            } );
        })
    </script>
@endsection

