@extends('layouts.admin')

@section('title', 'หน้าจอแบบการผลิต | เพิ่ม')

@section('content')


  <form action="{{ route("admin.form.store") }}" method="POST" enctype="multipart/form-data">
      @csrf

    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} {{ trans('global.form') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVGenerateName') ? 'has-error' : '' }}">
                <label for="XVGenerateName">{{ trans('global.TMgenerate.fields.XVGenerateName') }}*</label>
                <input type="text" id="XVGenerateName" name="XVGenerateName" class="form-control" maxlength="191" value="{{ old('XVGenerateName', isset($form) ? $form->XVGenerateName : '') }}" required autofocus>
                @if($errors->has('XVGenerateName'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVGenerateName') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMgenerate.fields.XVGenerateName_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.form.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
