@extends('layouts.admin')

@section('title', 'หน้าจอเพิ่ม Order | เพิ่ม')

@section('content')


  <form action="{{ route("admin.order.store") }}" method="POST" enctype="multipart/form-data">
      @csrf


    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }} {{ trans('global.Torder_hd.title') }}
        </div>

        <div class="card-body">


      </div>


      <div class="row justify-content-center">

                <div class="col-lg-4">

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XVOrderDocNo">เลขที่เอกสาร</label>
                        <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderDocNo" id="XVOrderDocNo" value="Auto" disabled="" style="font-size: 16px;">
                    </div>


                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XVOrderMItemNo">Item No :</label> <sub class="text-danger">&nbsp;&nbsp;&nbsp;</sub>
                      <input class="col-sm-12 form-control font-size" type="text" name="XVOrderMItemNo" id="XVOrderMItemNo" placeholder="Item No" style="font-size: 16px;">
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XVOrderMSeasion">Season :</label>
                       <select id="XISeasonCode" name="XISeasonCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($orders['season'] as $season)
                          <option value="{{ $season->XISeasonCode }}">{{ $season->XISeasonName }} </option>
                        @endforeach
                      </select>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XIForCode">แบบสำหรับ :</label>
                      <select id="XIForCode" name="XIForCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($orders['foruse'] as $foruse)
                          <option value="{{ $foruse->XIForCode }}">{{ $foruse->XVForType }} </option>
                        @endforeach
                      </select>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XIGuestCode">ชื่อลูกค้า :</label>
                      <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($orders['customer'] as $customer)
                          <option value="{{ $customer->XIGuestCode }}">{{ $customer->XVGuestName }} </option>
                        @endforeach
                      </select>
                    </div>


                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XISewCode">สถานที่เย็บหน้า หลัง :</label>
                      <select id="XISewCode" name="XISewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($orders['sews'] as $sews)
                          <option value="{{ $sews->XISewCode }}">{{ $sews->XVSewName }} </option>
                        @endforeach
                      </select>
                    </div>

                    <div class="form-group col-sm-12">
                      <label class="label-bold" for="XIBlenchCode">สถานที่ฟอก :</label>
                      <select id="XIBlenchCode" name="XIBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($orders['blenchs'] as $blenchs)
                          <option value="{{ $blenchs->XIBlenchCode }}">{{ $blenchs->XVBlenchName }} </option>
                        @endforeach
                      </select>
                    </div>

                </div>

                <!-- <div class="col-lg-1"></div> -->
                <div class="col-lg-4">

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="Workat">วันที่สร้างเอกสาร :</label>
                    <div class="end_date input-group mb-4">
                      <input class="form-control end_date" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderDocMDate" id="eratedate_datepicker"
                       value="<?php print DATE_FORMAT(NOW(),'d/m/Y')?>"
                       required="required">
                      <div class="input-group-append">
                        <span class="fa fa-calendar input-group-text end_date_calendar" aria-hidden="true "></span>
                      </div>
                    </div>
                  </div>
                    <div class="form-group col-sm-12">
                        <label class="label-bold" for="Workat">วันที่ต้องจัดส่ง :</label>
                        <div class="end_date input-group mb-4">
                            <input class="form-control end_date" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderOut" id="XDOrderOut"
                                   value="<?php print DATE_FORMAT(NOW(),'d/m/Y')?>"
                                   required="required">
                            <div class="input-group-append">
                                <span class="fa fa-calendar input-group-text end_date_calendar" aria-hidden="true "></span>
                            </div>
                        </div>
                    </div>
                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XVOrderMSeasion">แบบ Order :</label>
                     <select id="XIOrderTCode" name="XIOrderTCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($orders['ordertype'] as $ordertype)
                        <option value="{{ $ordertype->XIOrderTCode }}">{{ $ordertype->XVOrderTName }} </option>
                      @endforeach
                    </select>
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XVOrderIn">รหัสภายใน :</label> <sub class="text-danger">&nbsp;&nbsp;&nbsp;</sub>
                    <input class="col-sm-12 form-control font-size" type="text" name="XVOrderIn" id="XVOrderIn" placeholder="รหัสที่ใช้ภายใน" style="font-size: 16px;">
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XIGenerateCode">แบบงาน :</label>
                    <select id="XIGenerateCode" name="XIGenerateCode" class="col-sm-12 form-control font-size order_detail" type="text" required="required" style="font-size: 16px;">
                      @foreach ($orders['forms'] as $forms)
                        <option value="{{ $forms->XIGenerateCode }}">{{ $forms->XVGenerateName }} </option>
                      @endforeach
                    </select>
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XIShapeCode">ทรง :</label>
                    <select id="XIShapeCode" name="XIShapeCode" class="col-sm-12 form-control font-size order_detail" type="text" required="required" style="font-size: 16px;">
                      @foreach ($orders['shape'] as $shape)
                        <option value="{{ $shape->XIShapeCode }}">{{ $shape->XVShapeName }} </option>
                      @endforeach
                    </select>
                  </div>


                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XITotalSewCode">สถานที่เย็บ รวมตัว :</label>
                    <select id="XITotalSewCode" name="XITotalSewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($orders['totalsews'] as $totalsews)
                        <option value="{{ $totalsews->XITotalSewCode }}">{{ $totalsews->XVTotalSewName }} </option>
                      @endforeach
                    </select>
                  </div>

                  <div class="form-group col-sm-12">
                    <label class="label-bold" for="XIOrderTableCode">ชื่อโต๊ะตัด :</label>
                    <select id="XIOrderTableCode" name="XIOrderTableCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($orders['ordertable'] as $ordertable)
                        <option value="{{ $ordertable->XIOrderTableCode }}">{{ $ordertable->XVOrderTableName }} </option>
                      @endforeach
                    </select>
                  </div>

                </div>

                <div class="col-lg-4">
                  <div class="card" style="margin-right:15px">
                      <div class="card-header">
                          จำนวนที่สั่ง
                      </div>

                      <div class="card-body">

                      <div class="row mt-1">

                          <div class="input-group mb-3 col-sm-12">
                          <label class="label-bold" for="Workat">Size :</label>
                          </div>


                          <div class="input-group mb-3 col-sm-12">
                            <select type="number" class="col-sm-4 font-size" id="XVOrderDSize" style="font-size: 16px;" required="required">
                               @foreach ($orders['sizes'] as $size)
                                  <option value="{{ $size->size_id }}" >{{$size->size_name}} </option>
                              @endforeach
                            </select>
                            <input type="number" id="XIOrderDNum" class="form-control" placeholder="จำนวนสั่งผลิต" size="10" min="1" max="1000" autofocus>
                            <div class="input-group-append">
                              <button id="add-row" class="btn btn-success active" type="button">{{ trans('global.add') }}</button>
                            </div>
                          </div>

                          <div class="col">
                              <div class="table-responsive">
                                  <table id="Orderlist" class="table table-bordered table-striped table-hover datatable">
                                      <thead>
                                          <tr>
                                              <th width="33%">Size</th>
                                              <th width="33%">จำนวน</th>
                                              <th width="33%">Option</th>
                                          </tr>
                                      </thead>
                                      <tbody>

                                      </tbody>
                                  </table>
                              </div>
                          </div><!--col-->
                      </div><!--row-->

                      </div>

                  <div class="card-footer">
                      <div class="row">
                      </div>
                  </div>

                 </div>
              </div>
              <div class="col-lg-12">
                <div class="form-group col-sm-8">
                  <label class="label-bold" for="XVOrderDetail">Order Detial :</label> <sub class="text-danger">&nbsp;&nbsp;&nbsp;</sub>
                  <input class="col-sm-12 form-control font-size" type="text" name="XVOrderDetail" id="XVOrderDetail" placeholder="Order Detial" style="font-size: 16px;">
                </div>
              </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.order.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>

<script type="text/javascript">
  var i = 0;
  $("#eratedate_datepicker").datepicker()
  $("#XDOrderOut").datepicker()

$("#add-row").click(function(){
    bReturn = false;

    if ($("#XIOrderDNum").val() == 0){
        Swal.fire({
                icon:  'error',
                title: 'แจ้งเตือน',
                text:  'โปรดใส่จำนวนสั่งผลิต !',
                })
                bReturn = true;

    }
    if (bReturn) return false;

    $("input[name='XVOrderDSize[]']" ).each(function(){
        if ($(this).val() ==$('#XVOrderDSize').val()){
            Swal.fire({
                icon:  'error',
                title: 'แจ้งเตือน',
                text:  'มี Size  '+ $(this).val() +' นี้อยู่แล้วกรุณาตรวจสอบ !',
            })
            bReturn = true;
        }
    });
    if (bReturn) return false;

      i++;
      var text = $( "#XVOrderDSize option:selected" ).text();
      $('#Orderlist').append('<tr id=r'+i+'> <td><input type="hidden" value="'+$('#XVOrderDSize').val()+'" name="XVOrderDSize[]">'+text+'</td> <td><input type="hidden" value="'+$('#XIOrderDNum').val()+'" name="XIOrderDNum[]">'+$('#XIOrderDNum').val()+'</td> <td class="text-center"><button onclick="Rremoverow('+i+')" class="btn btn-danger" type="button">ลบ</button></td> </tr>');
      $("#XIOrderDNum").val("");

  });


  $('.order_detail').change(function(){
      $('#XVOrderDetail').val($('#XVOrderIn').val() + ' '+ $( "#XIGenerateCode option:selected" ).text() + ' '+ $( "#XIShapeCode option:selected" ).text())
  })

  $('#XVOrderIn').keyup(function(){
      $('#XVOrderDetail').val($('#XVOrderIn').val() + ' '+ $( "#XIGenerateCode option:selected" ).text() + ' '+ $( "#XIShapeCode option:selected" ).text())
  })

  function Rremoverow(i)
  {
    console.log(i);
    $('#r'+i).remove();
  }
</script>
@endsection
