@extends('layouts.admin')

@section('title', 'หน้าจอเพิ่ม Order | เพิ่ม')

@section('content')
    <div class="card">
        <form action="{{ route("admin.order.update", [$order['XVOrderDocNo']]) }}" method="POST" id="frm" enctype="multipart/form-data">
         @csrf
        @method('PUT')
        <input type="hidden" name="XCStatus" id="XCStatus" value="">
        <div class="card-header text-right col">
            กำหนดอุปกรณ์ให้กับ Order
            @switch($order['order_hd']->XCStatus)
                @case(2)
                    <span class="badge badge-success" style="cursor:pointer">{{ @$order['XDOrderDateApprove']}}</span>
                    @break
                @case(3)
                    <span class="badge badge-danger" style="cursor:pointer">ยกเลิก</span>
                        @break
                @case(4)
                    <span class="badge badge-dark" style="cursor:pointer">ไม่อนุมัติ</span>
                    @break
                @default
                    <span class="badge badge-warning" style="cursor:pointer">รออนุมัติ</span>
            @endswitch
        </div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group col-md-4">

                </div>
                <div class="form-group col-md-2">
                    <label for="text">เลขที่เอกสาร</label>
                    <input type="text" name="XVOrderDocNo" class="form-control text-center" id="" value="{{ old('XVOrderDocNo', isset($order) ? $order['XVOrderDocNo'] : 'Autoid') }}" readonly >
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่สร้าง Order</label>
                    <input type="text" name="XDOrderDocMDate" class="form-control text-center" id="text" value="{{ old('XDOrderDocMDate', isset($order['order_hd']) ? $order['order_hd']->XDOrderDocMDate : '') }}" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่อนุมัติ</label>
                    <input class="form-control end_date text-center" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderDateApprove"
                       value="{{ old('XDOrderDateApprove', isset($order['order_hd']->XDOrderDateApprove) ? DATE_FORMAT(new DateTime($order['order_hd']->XDOrderDateApprove),'d/m/Y') : DATE_FORMAT(NOW(),'d/m/Y')) }}"
                       required="required" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">item No:</label><sub class="text-danger">&nbsp;&nbsp;&nbsp;*</sub>
                    <input type="text" class="form-control text-center"  name="XVOrderMItemNo" id="XVOrderMItemNo" value="{{ old('XVOrderMItemNo', isset($order['order_hd']) ? $order['order_hd']->XVOrderMItemNo : '') }}"  required>
                </div>
            </div><!--end form row-->

            <div class="form-row">
                <div class="form-group col-md-2">
                    <label for="text">Season:</label>
                    <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderMSeasion" id="XVOrderMSeasion" value="{{ old('XVOrderMSeasion', isset($order['order_hd']) ? $order['order_hd']->XVOrderMSeasion : '') }}"   placeholder="Season" style="font-size: 16px;">
                </div>
                <div class="form-group col-md-2">
                    <label for="text">ลูกค้า</label>
                   <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['customer'] as $customer)
                          <option value="{{ $customer->XIGuestCode }}" {{ old('XIGuestCode', (isset($order['order_hd']) && $order['order_hd']->XIGuestCode == $customer->XIGuestCode) ? 'selected' : '') }}>{{ $customer->XVGuestName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">สำหรับ/</label>
                    <select id="XIForCode" name="XIForCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($order['foruse'] as $foruse)
                        <option value="{{ $foruse->XIForCode }}" {{ old('XIForCode', (isset($order['order_hd']) && $order['order_hd']->XIForCode == $foruse->XIForCode) ? 'selected' : '') }}>{{ $foruse->XVForType }} </option>
                      @endforeach
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="text">แบบงาน</label>
                    <select id="XIGenerateCode" name="XIGenerateCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['forms'] as $forms)
                          <option value="{{ $forms->XIGenerateCode }}" {{ old('XIGenerateCode', (isset($order['order_hd']) && $order['order_hd']->XIGenerateCode == $forms->XIGenerateCode) ? 'selected' : '') }}>{{ $forms->XVGenerateName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="text">ทรง</label>
                    <select id="XIShapeCode" name="XIShapeCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($order['shape'] as $shape)
                        <option value="{{ $shape->XIShapeCode }}" {{ old('XIShapeCode', (isset($order['order_hd']) && $order['order_hd']->XIShapeCode == $shape->XIShapeCode) ? 'selected' : '') }}>{{ $shape->XVShapeName }} </option>
                      @endforeach
                    </select>
                </div>
            </div><!--end form row-->

            <div class="col-lg-12">
                <div class="card-body text-center">
                        @php
                            $sum_order =0;
                            $sum_per =0;
                            $sum_total =0;
                        @endphp
                        <table class="table table-bordered " >
                            <thead class="text-white bg-dark">
                                <tr>
                                    <th scope="col">Size</th>
                                     @foreach ($order['order_dt'] as $key =>$order_dt)
                                        <td>{{ old('XVOrderDSize', isset($order_dt) ? $order_dt['XVOrderDSize'] : '') }}</td>
                                    @endforeach
                                    <th scope="col" style="width:150px">Total</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td scope="row">ออเดอร์ไทย</td>
                                    @foreach ($order['order_dt'] as $key =>$order_dt)
                                    @php
                                        $sum_order +=$order_dt['XIOrderDNum'];
                                    @endphp
                                        <td>{{ old('XIOrderDNum', isset($order_dt) ? $order_dt['XIOrderDNum'] : '') }}</td>
                                    @endforeach
                                        <td>{{ number_format($sum_order)}}</td>
                                </tr>
                                <tr>
                                    <td scope="row">ตัดเพื่อ 5%</td>
                                    @foreach ($order['order_dt'] as $key =>$order_dt)
                                    @php
                                        $sum_per +=$order_dt['XIOrderDNum5P'];
                                    @endphp
                                        <td>{{ old('XIOrderDNum5P', isset($order_dt) ? $order_dt['XIOrderDNum5P'] : '') }}</td>
                                    @endforeach
                                        <td>{{ number_format($sum_per)}}</td>
                                </tr>
                                <tr>
                                    <td scope="row">รวม</td>
                                    @foreach ($order['order_dt'] as $key =>$order_dt)
                                        <td>{{ old('XIOrderDTotalNum', isset($order_dt) ? $order_dt['XIOrderDTotalNum'] : '') }}</td>
                                    @endforeach

                                        <td>{{ number_format($sum_order + $sum_per)}}</td>

                                </tr>

                            </tbody>
                        </table>
                    </div><!--card body-->
            </div><!--div-->

            <div  class="row">
                <div class="form-group col-md-4">
                    <label for="text">สถานที่เย็บ หน้าหลัง</label>
                    <select id="XISewCode" name="XISewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['sews'] as $sews)
                          <option value="{{ $sews->XISewCode }}" {{ old('XISewCode', (isset($order['order_hd']) && $order['order_hd']->XISewCode == $sews->XISewCode) ? 'selected' : '') }}>{{ $sews->XVSewName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="text">สถานที่เย็บ รวมตัว</label>
                     <select id="XITotalSewCode" name="XITotalSewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                      @foreach ($order['totalsews'] as $totalsews)
                        <option value="{{ $totalsews->XITotalSewCode }}" {{ old('XITotalSewCode', (isset($order['order_hd']) && $order['order_hd']->XITotalSewCode == $totalsews->XITotalSewCode) ? 'selected' : '') }}>{{ $totalsews->XVTotalSewName }} </option>
                      @endforeach
                    </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="text" >สถานที่เย็บ ฟอก</label>
                    <select id="XIAddBlenchCode" name="XIAddBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        @foreach ($order['blenchs'] as $blenchs)
                          <option value="{{ $blenchs->XIBlenchCode }}" {{ old('XIBlenchCode', (isset($order['order_hd']) && $order['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }}>{{ $blenchs->XVBlenchName }} </option>
                        @endforeach
                      </select>
                </div>
            </div>

            <div class="col-lg-12" >
                <div class="card ">
                    {{-- <div class="card-header text-white bg-secondary"> --}}
                    <div class="card-header text-right">
                        รายการอุปกรณ์
                    </div>
                    <div class="card-body">
                        <div class="form row">
                            <div class="form-group col-md-4">
                                <label for="text" >รหัส</label>
                                <select id="XVAccesCode" name="XVAccesCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                                    @foreach ($accessories['XVAccesCode'] as $accno)
                                      {{-- <option value="{{ $accno->XVAccesCode }}" {{ old('XIBlenchCode', (isset($order['order_hd']) && $order['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }}>{{ $blenchs->XVBlenchName }} </option> --}}
                                      <option value="{{ $accno->XVAccesCode }}">{{ $accno->XVAccesCode }}</option>
                                    @endforeach
                                  </select>
                            </div>
                            <div style="width:60px;margin-left:15px">
                                <label for="formGroupExampleInput2">รหัส/</label>
                                <div class="form-group ">
                                    <select id="inputState" class="form-control">
                                        <option selected></option>
                                        <option>...</option>
                                    </select>
                                </div>
                            </div>
                            <div style="width:147px;margin-left:5px">
                                <label for="text" >ชื่อ:</label>
                                <input type="text" class="form-control text-left"  placeholder="ป้ายกระดาษขอบเอว"readonly >
                            </div>
                            <div style="width:231px;margin-left:5px">
                                <label for="text" >:</label>
                                <input type="text" class="form-control text-left"  placeholder="-"readonly >
                            </div>
                            <div style="width:50px;margin-left:2px">
                                <label for="formGroupExampleInput2">ใช้กับ:</label>
                                <div class="form-group ">
                                    <select id="inputState" class="form-control">
                                        <option selected>28</option>
                                        <option>...</option>
                                    </select>
                                </div>
                            </div>
                            <div style="width:50px;margin-left:2px">
                                <label for="text" >จำนวน:</label>
                                <input type="text" class="form-control text-left"  placeholder="158" >
                            </div>
                            <div style="width:176px;margin-left:2px">
                                <label for="formGroupExampleInput2">เเผนกที่เบิก:</label>
                                <div class="form-group ">
                                    <select id="inputState" class="form-control">
                                        <option selected>Packing</option>
                                        <option>...</option>
                                    </select>
                                </div>
                            </div>
                            <div style="width:230px;margin-left:2px">
                                <label for="text" >ที่เก็บรูป:</label>
                                <input type="text" class="form-control text-left"  placeholder="xxxxx" >
                            </div>
                            <div style="width:60px;high:60px;margin-left:15px;margin-top:25px">
                               <span class="glyphicon glyphicon-plus-sign"></span>
                            </div>
                        </div>
                        <table class="table table-bordered ">
                            <thead class="text-white bg-secondary">
                                <tr>
                                    <th scope="col" style="width:60px">รหัส</th>
                                    <th scope="col" style="width:150px">ชื่อ</th>
                                    <th scope="col">รายละเอียด</th>
                                    <th scope="col" style="width:50px">ใช้กับ</th>
                                    <th scope="col"  style="width:60px">จำนวน</th>
                                    <th scope="col "style="width:90px">ราคาต่อหน่วย</th>
                                    <th scope="col" style="width:80px">รวม</th>
                                    <th scope="col">เเผนกที่เบิก</th>
                                    <th scope="col" style="width:70px">Option</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                <th scope="row">xxx</th>
                                    <td>WASH CARE</td>
                                    <td>เเบบสอด/ทอ</td>
                                    <th>28</th>
                                    <th>158</th>
                                    <th>0.15</th>
                                    <th>23.70</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>WASH CARE</td>
                                    <td>เเบบสอด/ทอ</td>
                                    <th>30</th>
                                    <th>263</th>
                                    <th>39.45</th>
                                    <th>23.70</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>WASH CARE</td>
                                    <td>เเบบสอด/ทอ</td>
                                    <th>32</th>
                                    <th>263</th>
                                    <th>0.15</th>
                                    <th>39.45</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>WASH CARE</td>
                                    <td>เเบบสอด/ทอ</td>
                                    <th>34</th>
                                    <th>263</th>
                                    <th>0.15</th>
                                    <th>39.45</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>WASH CARE</td>
                                    <td>เเบบสอด/ทอ</td>
                                    <th>36</th>
                                    <th>210</th>
                                    <th>0.15</th>
                                    <th>31.50</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>WASH CARE</td>
                                    <td>เเบบสอด/ทอ</td>
                                    <th>38</th>
                                    <th>105</th>
                                    <th>0.15</th>
                                    <th>15.75</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>ด้ายเย็บ</td>
                                    <td>NO.20</td>
                                    <th>All</th>
                                    <th>4</th>
                                    <th>0.67</th>
                                    <th>2.68</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>ด้ายโพง</td>
                                    <td>NO.30</td>
                                    <th>All</th>
                                    <th>3</th>
                                    <th>0.67</th>
                                    <th>2.01</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>ด้ายถักรัง</td>
                                    <td>NO.60</td>
                                    <th>All</th>
                                    <th>2</th>
                                    <th>0.39</th>
                                    <th>0.78</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                                <tr>
                                    <th scope="row">xxx</th>
                                    <td>สัญญาณกันขโมย</td>
                                    <td>-</td>
                                    <th>All</th>
                                    <th>1260</th>
                                    <th>1.00</th>
                                    <th>1260</th>
                                    <th>เย็บ</th>
                                    <th>ลบ</th>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div><!--card-->
            </div><br><!--card-->



        </div><!--end card body-->
                          <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.order.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                @if ($order['order_hd']->XCStatus !="3" && $order['order_hd']->XCStatus !="4" )
                <input class="btn_submit btn btn-success active  ml-1 col-3" data-status="2" type="button" value="แก้ไขและอนุมัติ">
                @endif

                @if ($order['order_hd']->XCStatus =="1" )
                <input class="btn_submit btn btn-primary active  ml-1 col-2" data-status="1" type="button" value="แก้ไข ">
                @endif

                @if ($order['order_hd']->XCStatus =="1" )
                <input class="btn_submit btn btn-dark active  ml-1 col-2" data-status="4" type="button" value="ไม่อนุมัติ ">
                 @endif

              </div>
          </div>
      </div>
        </form>
    </div><!--end card-->

@endsection


@section('scripts')
<script type="text/javascript">
$( document ).ready(function() {
    $("#eratedate_datepicker").datepicker()

    $(".btn_submit").click(function(){
        var status = $(this).data('status')

        if ($('#XVOrderMItemNo').val() == ''){
            Swal.fire({
                title: 'Oops....',
                text: "กรุณากรอก Item No",
                icon: 'warning',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'OK'
                });

        }else{
            $("#XCStatus").val(status)
            $("#frm").submit();
        }

    })
})
</script>

@endsection
