@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
<style>
    a {
        color: brown;
    }
</style>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รายละเอียด
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/ordercheck') }}" class="btn btn-danger ml-1" data-toggle="tooltip" title="กลับ"><i class="fas fa-caret-square-left"></i></a>
                    </div>
                </div><!--col-->
            </div><!--row-->
            @php
                // dd("test ScBox");

            @endphp
            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                <th width="8%">Code</th>
                                <th width="10%">Date</th>
                                <th width="15%">SKU</th>
                                <th width="13%">Item Number</th>
                                <th width="5%">Size</th>
                                <th width="5%">จำนวน</th>
                                <th width="10%">สถานะ</th>
                                <th width="25%">หมายเหตุ</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 50,
                "ajax": {
                    url : "{{url('')}}/admin/planbookdetial1/{{ $skuid }}",
                    data:{location:5} ,
                },
                "columnDefs": [
                    {
                        "targets": 0, // your case first column
                        "className": "text-center",
                    },
                    {
                        "targets": 1, // your case first column
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // your case first column
                        "className": "text-left",
                    },
                    {
                        "targets": 3, // your case first column
                        "className": "text-left",
                    },
                    {
                        "targets": 4, // your case first column
                        "className": "text-center",
                    },
                    {
                        "targets": 5, // your case first column
                        "className": "text-right",
                    },
                    {
                        "targets": 6, // your case first column
                        "className": "text-left",
                    }
                ],
                "columns": [
                    { data: 'XIIOID'},
                    {
                        render: function(data, type, row ,meta){

                                return moment(row.XDIODate).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVIOSKUin'},
                    { data: 'XVOrderIn'},
                    { data: 'XVStVkSize'},
                    { data: 'XIIONum'},
                    { render: function (data,type,row,meta)
                        {
                            switch (row.XIIOSta)
                            {
                                case '88':
                                    return 'สั่งผลิต' ;
                                    break;
                                case '9':
                                    return 'ลงกล่อง' ;
                                    break;
                                case '15':
                                    return 'Packing' ;
                                    break;
                                case '5':
                                    return 'FG' ;
                                    break;
                                case '6':
                                    return 'QC' ;
                                    break;
                                case '99':
                                    return 'Store' ;
                                    break;
                                case '16':
                                    return 'จอง' ;
                                    break;
                                case '33':
                                    return 'ตัด' ;
                                    break;
                                case '34':
                                    return 'เย็บ' ;
                                    break;
                                case '3':
                                    return 'ฟอก' ;
                                    break;
                                default:
                                    return 'ไม่มีค่า' ;
                            }
                        }
                    },
                    { data: 'XVOinoutNote'}

                ],
            } );
        })
    </script>
@endsection

