@extends('layouts.admin')

@section('title', 'หน้าจอเพิ่ม Order | เพิ่ม')
@section('styles')
<style type="text/css">
.img-wrap {
    position: relative;
    display: inline-block;
    border: 1px red solid;
    margin: 5px;
    font-size: 0;
}
.img-wrap img {
    max-width:100%;
    max-height:100%;
}
.img-wrap .close {
    position: absolute;
    top: 2px;
    right: 2px;
    z-index: 100;
    background-color: #FFF;
    padding: 5px 2px 2px;
    color: #000;
    font-weight: bold;
    cursor: pointer;
    opacity: .2;
    text-align: center;
    font-size: 22px;
    line-height: 10px;
    border-radius: 50%;
}
.img-wrap:hover .close {
    opacity: 1;
}
</style>
@endsection;

@section('content')
    <div class="card">
        <form action="{{ route("admin.picturedefective.update", [$order['XVOrderDocNo']]) }}" accept-charset="utf-8"  method="POST" id="frm" enctype="multipart/form-data">

         @csrf
        @method('PUT')
        <input type="hidden" name="XCStatus" id="XCStatus" value="">
        <div class="card-header col">
            รูปตำหนิ
            @switch($order['order_hd']->XCStatus)
                @case(2)
                    <span class="badge badge-success" style="cursor:pointer">{{ @$order['XDOrderDateApprove']}}</span>
                    @break
                @case(3)
                    <span class="badge badge-danger" style="cursor:pointer">ยกเลิก</span>
                        @break
                @case(4)
                    <span class="badge badge-dark" style="cursor:pointer">ไม่อนุมัติ</span>
                    @break
                @default
                    <span class="badge badge-warning" style="cursor:pointer">รออนุมัติ</span>
            @endswitch
        </div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group col-md-4">

                </div>
                <div class="form-group col-md-2">
                    <label for="text">เลขที่เอกสาร</label>
                    <input type="text" name="XVOrderDocNo" class="form-control text-center" id="" value="{{ old('XVOrderDocNo', isset($order) ? $order['XVOrderDocNo'] : 'Autoid') }}" disabled >
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่สร้าง Order</label>
                    <input type="text" name="XDOrderDocMDate" class="form-control text-center" id="text" value="{{ old('XDOrderDocMDate', isset($order['order_hd']) ? $order['order_hd']->XDOrderDocMDate : '') }}" disabled>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่อนุมัติ</label>
                    <input class="form-control end_date text-center" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderDateApprove"
                       value="{{ old('XDOrderDateApprove', isset($order['order_hd']->XDOrderDateApprove) ? DATE_FORMAT(new DateTime($order['order_hd']->XDOrderDateApprove),'d/m/Y') : DATE_FORMAT(NOW(),'d/m/Y')) }}"
                       required="required" disabled>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">item No:</label><sub class="text-danger">&nbsp;&nbsp;&nbsp;*</sub>
                    <input type="text" class="form-control text-center"  name="XVOrderMItemNo" id="XVOrderMItemNo" value="{{ old('XVOrderMItemNo', isset($order['order_hd']) ? $order['order_hd']->XVOrderMItemNo : '') }}"  required disabled>
                </div>
            </div><!--end form row-->

            <div class="form-row">
                <div class="form-group col-md-2">
                    <label for="text">Season:</label>
                    <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderMSeasion" id="XVOrderMSeasion" value="{{ old('XVOrderMSeasion', isset($order['order_hd']) ? $order['order_hd']->XVOrderMSeasion : '') }}"   placeholder="Season" style="font-size: 16px;" disabled>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">ลูกค้า</label>
                   <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled>
                        @foreach ($order['customer'] as $customer)
                          <option value="{{ $customer->XIGuestCode }}" {{ old('XIGuestCode', (isset($order['order_hd']) && $order['order_hd']->XIGuestCode == $customer->XIGuestCode) ? 'selected' : '') }}>{{ $customer->XVGuestName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">สำหรับ/</label>
                    <select id="XIForCode" name="XIForCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled>
                      @foreach ($order['foruse'] as $foruse)
                        <option value="{{ $foruse->XIForCode }}" {{ old('XIForCode', (isset($order['order_hd']) && $order['order_hd']->XIForCode == $foruse->XIForCode) ? 'selected' : '') }}>{{ $foruse->XVForType }} </option>
                      @endforeach
                    </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="text">แบบงาน</label>
                    <select id="XIGenerateCode" name="XIGenerateCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled>
                        @foreach ($order['forms'] as $forms)
                          <option value="{{ $forms->XIGenerateCode }}" {{ old('XIGenerateCode', (isset($order['order_hd']) && $order['order_hd']->XIGenerateCode == $forms->XIGenerateCode) ? 'selected' : '') }}>{{ $forms->XVGenerateName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-3">
                    <label for="text">ทรง</label>
                    <select id="XIShapeCode" name="XIShapeCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled >
                      @foreach ($order['shape'] as $shape)
                        <option value="{{ $shape->XIShapeCode }}" {{ old('XIShapeCode', (isset($order['order_hd']) && $order['order_hd']->XIShapeCode == $shape->XIShapeCode) ? 'selected' : '') }}>{{ $shape->XVShapeName }} </option>
                      @endforeach
                    </select>
                </div>
            </div><!--end form row-->

            <div class="col-lg-12">
                <div class="card-body text-center">
                        @php
                            $sum_order =0;
                            $sum_per =0;
                            $sum_total =0;
                        @endphp
                        <table class="table table-bordered " >
                            <thead class="text-white bg-dark">
                                <tr>
                                    <th scope="col">Size</th>
                                     @foreach ($order['order_dt'] as $key =>$order_dt)
                                        <td>{{ old('XVOrderDSize', isset($order_dt) ? $order_dt['XVOrderDSize'] : '') }}</td>
                                    @endforeach
                                    <th scope="col" style="width:150px">Total</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td scope="row">ออเดอร์ไทย</td>
                                    @foreach ($order['order_dt'] as $key =>$order_dt)
                                    @php
                                        $sum_order +=$order_dt['XIOrderDNum'];
                                    @endphp
                                        <td>{{ old('XIOrderDNum', isset($order_dt) ? $order_dt['XIOrderDNum'] : '') }}</td>
                                    @endforeach
                                        <td>{{ number_format($sum_order)}}</td>
                                </tr>
                                <tr>
                                    <td scope="row">ตัดเพื่อ 5%</td>
                                    @foreach ($order['order_dt'] as $key =>$order_dt)
                                    @php
                                        $sum_per +=$order_dt['XIOrderDNum5P'];
                                    @endphp
                                        <td>{{ old('XIOrderDNum5P', isset($order_dt) ? $order_dt['XIOrderDNum5P'] : '') }}</td>
                                    @endforeach
                                        <td>{{ number_format($sum_per)}}</td>
                                </tr>
                                <tr>
                                    <td scope="row">รวม</td>
                                    @foreach ($order['order_dt'] as $key =>$order_dt)
                                        <td>{{ old('XIOrderDTotalNum', isset($order_dt) ? $order_dt['XIOrderDTotalNum'] : '') }}</td>
                                    @endforeach

                                        <td>{{ number_format($sum_order + $sum_per)}}</td>

                                </tr>

                            </tbody>
                        </table>
                    </div><!--card body-->
            </div><!--div-->

            <div  class="row">
                <div class="form-group col-md-4">
                    <label for="text">สถานที่เย็บ หน้าหลัง</label>
                    <select id="XISewCode" name="XISewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled>
                        @foreach ($order['sews'] as $sews)
                          <option value="{{ $sews->XISewCode }}" {{ old('XISewCode', (isset($order['order_hd']) && $order['order_hd']->XISewCode == $sews->XISewCode) ? 'selected' : '') }}>{{ $sews->XVSewName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="text">สถานที่เย็บ รวมตัว</label>
                     <select id="XITotalSewCode" name="XITotalSewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled>
                      @foreach ($order['totalsews'] as $totalsews)
                        <option value="{{ $totalsews->XITotalSewCode }}" {{ old('XITotalSewCode', (isset($order['order_hd']) && $order['order_hd']->XITotalSewCode == $totalsews->XITotalSewCode) ? 'selected' : '') }}>{{ $totalsews->XVTotalSewName }} </option>
                      @endforeach
                    </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="text" >สถานที่เย็บ ฟอก</label>
                    @php
                        // dd($order['order_hd'], $order['blenchs'])
                    @endphp
                    <select id="XIBlenchCode" name="XIBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" disabled>
                        @foreach ($order['blenchs'] as $blenchs)
                          <option value="{{ $blenchs->XIBlenchCode }}" {{ old('XIBlenchCode', (isset($order['order_hd']) && $order['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }}>{{ $blenchs->XVBlenchName }} </option>
                        @endforeach
                      </select>
                </div>
            </div>

            <div>
                <fieldset>
                    <legend>รูปตำหนิ :</legend>
                    @if ($message = Session::get('success'))
                    <div class="alert alert-success alert-block">
                        <button type="button" class="close" data-dismiss="alert">×</button>
                            <strong>{{ $message }}</strong>
                    </div>
                    <br>
                    @endif

                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <strong>Opps!</strong> There were something went wrong with your input.
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    <br>
                    @endif

                    <div class="avatar-upload col-6">
                        <div class=" form-group avatar-edit">
                            <p ><mark> Ctrl หรือ Shift ค้างไว้ด้วยพร้อม ๆ กับการกดเมาส์เพื่อเลือกทีละหลาย ๆ ไฟล์</mark></p>
                            <input required type="file" class="form-control"  id="image" name="image[]" accept=".png, .jpg, .jpeg" multiple required />
                            <label for="imageUpload"></label>
                        </div>
                        <input class="btn_submit btn btn-success active  ml-1 col-4" data-status="2" type="submit" value="บันทึกรูปตำหนิ">
                    </div>
                                  <div class="col text-right">
              </div>

                    @if (@count($order['order_img']) > 0)
                        @foreach ($order['order_img'] as $img)
                            <div class="img-wrap">
                                <span class="close">&times;</span>
                                <img src="{{ url('/image_order').'/'.@$img['XVImgName']}}" data-id="{{ @$img['XISeqNo'] }}">
                            </div>
                        @endforeach
                    @endif

                </fieldset>

            </div>

        </div><!--end card body-->
        <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.picturedefective.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>


          </div>
      </div>
        </form>
    </div><!--end card-->

@endsection


@section('scripts')
<script type="text/javascript">
$( document ).ready(function() {
    $('.img-wrap .close').on('click', function() {
        var id = $(this).closest('.img-wrap').find('img').data('id');
        var DocNo = "{{$order['XVOrderDocNo']}}"

        Swal.fire({
                title: 'ยืนยันการลบ ?',
                text: "คุณต้องการลบรายการเลขที่ "+ id +" ใช่หรือไม่ !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'ยืนยัน !',
                cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                if (result.value) {
                    $('#frm').attr('action','{{ url('admin/picturedefective/del') }}'+'/'+id+'/'+DocNo)
                    $('#frm').submit();
                }
                })
    });
})
</script>

@endsection
