@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        ตรวจสอบ Order
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        {{-- <a href="{{ url('admin/cutcloth/inputcut') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a> --}}
                    </div>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable" style="width:100%">
                            <thead>
                            <tr>
                                <th style="width:10%">Item Number</th>
                                <th style="width:3%">Size</th>
                                <th style="width=3%">Order</th>
                                <th style="width=3%">Cut</th>
                                <th style="width=3%">FG</th>
                                <th style="width=3%">QC</th>
                                <th style="width=3%">ซ่อม</th>
                                <th style="width=3%">EJ</th>
                                <th style="width=3%">PK</th>
                                <th style="width=3%">Box</th>
                                <th style="width=3%">OH</th>
                                <th style="width=5%">Option</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                "scrollX" : true,
                pageLength: 25,
                "ajax": {
                    url : "{{url('')}}/admin/planbookgetdata2",
                },
                "columnDefs": [
                    {
                        "targets": 0, // เลขที่
                        "className": "text-left",
                    },
                    {
                        "targets": 1, // เลขที่
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 3, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 4, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 5, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 6, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 7, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 8, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 9, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 10, // เลขที่
                        "className": "text-right",
                    },
                    {
                        "targets": 11, // เลขที่
                        "className": "text-center",
                    },
 ],
                "columns": [
                    { data: 'itemn'},
                    { data: 'size'},
                    { data: 'pl'},
                    { data: 'cut1'},
                    { data: 'fg'},
                    { data: 'qc'},
                    { data: 're1'},
                    { data: 'ej'},
                    { data: 'pk'},
                    { data: 'box1'},
                    { data: 'sum2'},
                    // { data: 'blench1'},
                    // { data: 'kradum1'},
                    // { data: 'fg'},
                    // { data: 'qc'},
                    // { data: 're1'},
                    // { data: 'ej'},
                    // { data: 'pk'},
                    {
                        render: function (data, type, full, meta ) {
                            console.log(full);
                            return '<a href="{{url('admin/planbook/showd')}}/'+full.itemn+'/'+full.size+'" class="btn btn-warning" data-toggle="tooltip" data-placement="top" title="รายละเอียด"><i class="fas fa-book-open"></i></a>';
                            // return ' <a href="{{url('admin/cutcloth/showd')}}/'+full.XVOrderDocNo2+'/'+full.TableCut+'/'+full.XVOrderIn+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                        }
                    },
                ],
            } );
        })
    </script>
@endsection

