@extends('layouts.admin')

@section('title', env('APP_NAME') . ' |  ลูกค้าสั่ง PPE')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    จัด PPE ลงกล่อง
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/ppe/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>เลขที่</th>
                            <th>Order</th>
                            <th>ชื่อผู้ติดต่อ</th>
                            <th>กำหนดส่ง</th>
                            <th>ชื่อผู้รับของ</th>
                            <th>จัดกล่อง</th>
                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script>
        @if(session('message'))
              Swal.fire({
                    title: "Message",
                    text: '{{session('message')}}',
                    icon: 'success',
                        })
        @endif
   </script>
    <script>
        $(document).ready(function() {


            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/ppegetdata",
                    data:{location:9} , 
                    },
                "columns": [
                    { data: 'XIPpeCode' },
                    { data: 'XVPpeOrderId' },
                    { data: 'XVPpeContactName' },
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDPpeSendDate).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVPpeRecipName' },
                    {
                        render: function (data, type, full, meta ) {
                            // console.log(full);

                              return ' <a href="{{url('admin/ppebox/create')}}/'+full.XIPpeCode+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                            //return '<a href="{{url('admin/ppeedit')}}?id='+full.XIPpeCode+'"><button>แก้ไข</button></a>';
                        }
                    }

                ]
            } );
        })
    </script>
    @endsection

{{-- group order size --}}
