@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | กำหนดราคางานฟอก')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    กำหนดราคางานฟอก
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">

            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table table-bordered table-striped table-hover datatable">
                        <thead>
                        <tr>
                            <th>วันที่อนุมัติ</th>
                            <th>เลขที่</th>
                            <th>Item No.</th>
                            <th>จำนวน</th>
                            <th>ราคา</th>
                            <th>ชื่อโรงฟอก</th>
                            <th>Option</th>
                        </tr>
                        </thead>
                        <tbody>

                            @foreach($shipping['box'] as $key => $box)
                            <tr >
                                <td>
                                    {{ $box->XDOrderDocMDate ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XVOrderDocNo ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XVOrderMItemNo ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XDOrderDocMDate ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XDOrderBPrince ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XDOrderDocMDate ?? '' }}
                                </td>

                                <td style="text-align:center" >
                                    @can('order_edit')
                                        <a href="{{ route('admin.priceworkbleach.getApprove', $box->XVOrderDocNo)}}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="รายละเอียด">
                                            <i class="fas fa-edit">รายละเอียด</i>
                                        </a>
                                  @endcan
                                </td>
                            </tr>
                        @endforeach


                        </tbody>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script>
      $(function () {


          $('.datatable:not(.ajaxTable)').DataTable({
              "pageLength": 25
          })
      })
</script>
@endsection


