@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รายการสินค้าซ่อม
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/qcre/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/qcre/report') }}" class="btn btn-info ml-2" data-toggle="tooltip" title="พิมพ์"><i class="fas fa-print"></i></a>
                    </div>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                <th>เลขที่</th>
                                <th>วันที่</th>
                                <th>SKU</th>
                                <th>Item Number</th>
                                <th>Size</th>
                                <th>จำนวน</th>
                                <th>แก้ไข</th>
                                <th>ลบ</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/qcregetdata",
                },
                "columnDefs": [
                    {
                        "targets": 0, // เลขที่
                        "className": "text-center",
                    },
                    {
                        "targets": 1, // วันที่
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // SKU
                        "className": "text-left",
                    },
                    {
                        "targets": 3, // Item Number
                        "className": "text-left",
                    },
                    {
                        "targets": 4, // Size
                        "className": "text-center",
                    },
                    {
                        "targets": 5, // จำนวน
                        "className": "text-right",
                    },
                    {
                        "targets": 6, // แก้ไข
                        "className": "text-center",
                    },
                    {
                        "targets": 7, // ลบ
                        "className": "text-center",
                    },
                ],
                "columns": [
                    { data: 'XIIOID'},
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDIODate).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVIOSKUin'},
                    { data: 'XVOrderIn'},
                    { data: 'XVStVkSize'},
                    { data: 'XIIONum'},
                    {
                        render: function (data, type, full, meta ) {
                            // console.log(full);

                              return ' <a href="{{url('admin/qcre/edit')}}/'+full.XIIOID+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                        }
                    },
                    {
                        render: function (data, type, full, meta ) {
                            // console.log(full);

                              return ' <a href="{{url('admin/qcre/del')}}/'+full.XIIOID+'" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="ลบ"><i class="fas fa-trash-alt"></i></a>';
                        }
                    }
                ],
            } );
        })
    </script>
@endsection

