@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    @if(Session::has('success'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <strong>Success!</strong> {{ Session::get('success') }}
                        </div>
                    @elseif(Session::has('failed'))
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <strong>Fail!</strong> {{ Session::get('failed') }}
                        </div>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รับงานเย็บ
                    </h4>
                </div><!--col-->

                {{-- <div class="col-sm-7 pull-right">
                        <div class="btn-toolbar float-right">
                            <a href="{{ url('admin/scanforbleachingjobs/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                        </div>
                </div><!--col--> --}}
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                <th scope="col">เลขที่</th>
                                <th scope="col">รหัสภายใน</th>
                                <th scope="col">รายละเอียด</th>
                                <th scope="col">Size</th>
                                <th scope="col">จำนวน</th>
                                <th scope="col">จัดการ</th>
                            </tr>
                            </thead>

                        </table>

                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->

                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {

            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/receiveItemGetData",
                    data:{location:2} ,
                },

                "columns": [
                    { data: 'XVOrderDocNo' },
                    { data: 'XVOrderIn' },
                    { data: 'XVOrderDetail' },
                    { data: 'XVOrderDSize' },
                    { data: 'XIOrderDTotalNum' },
                    {
                        render: function ( data, type, row ) {
                            // console.log(row)
                            // return '<a href="'+row.name+'">Edit</a>';
                            return '<a href="{{url('/admin/receive/receiveItem/confirm')}}/'+row.XVOrderDocNo+'/'+row.XVOrderIn+'/'+row.XVOrderDSize+'/'+row.XIOrderDTotalNum+'"><button class="btn btn-primary"><i class="fas fa-edit"></i></button></a>';
                        }
                    }
//+'/'+full.XVOrderIn+'/'+full.XVOrderDSize+'/'+full.XIOrderDTotalNum
                    // {defaultContent: '<button class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></button>'}
                ]
            });

            $('#datatable tbody').on( 'click', 'button', function () {
                var data = $(this).parents('tr')
                console.log(data)
                // alert( data[0] +"'s salary is: "+ data[ 5 ] );
            } );

        })
    </script>
@endsection
