@extends('layouts.admin')

@section('title', env('APP_NAME') . ' |  รายงานสินค้าคงค้าง')

@section('content')

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header text-white bg-dark">
                            รายงานสินค้าคงค้าง
                    </div><!--card-header-->
                     <div class="card-body">
                            <table  class="table table-bordered table-striped table-hover datatable" id="datatable" style="width:100%">
                                    <thead class="text-white bg-dark ">
                                        <tr >
                                            <th>ลำดับ</th>
                                            <th>เลขที่ Order</th>
                                            <th>รายละเอียด</th> 
                                            <th>Size</th>
                                            <th>เลขที่ Barcode</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $row =1;
                                        @endphp
                                        @foreach ($datas as $item)
                                        <tr>
                                            <td>{{ $row++}}</td>
                                            <td>{{ $item->XVOrderDocNo}}</td>
                                            <td>{{ $item->XVOrderDetail}}</td>
                                            <td>{{ $item->XVOrderBSize}}</td>
                                            <td>{{ $item->XVOrderBCode}}</td>
                                        </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                        </div>
                        <div class="card-footer">
                                <div class="row">
                                    <div class="col">
                                        <a href="{{route('admin.reportBalance')}}" class="btn btn-dark col-lg-2 active" role="button" aria-pressed="true">กลับ</a>
                                    </div>

                                </div>
                                </div>
                </div><!--card-->
            </div><!--col-->
        </div><!--row-->

@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
        $(document).ready(function() {


            $('#datatable').DataTable( {
            } );
        })
    </script>
    @endsection


