@extends('layouts.admin')

@section('title', ' กำหนดราคางานฟอก')

@section('content')
    <div class="card">
        <form action="{{ route("admin.setpricebleach.update", [$order['XVOrderDocNo']]) }}" method="POST" id="frm" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        {{-- <input type="hidden" name="XCStatus" id="XCStatus" value=""> --}}
        <div class="card-header text-left col">
            กำหนดราคางานฟอก
        </div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group col-md-2">
                    <label for="text">เลขที่เอกสาร</label>
                     <input type="text" name="XVOrderDocNo" class="form-control text-right" id="" value="{{ old('XVOrderDocNo', isset($order) ? $order['XVOrderDocNo'] : 'Autoid') }}" readonly >
                </div>
                <div class="form-group col-md-2">
                    <label for="text">รหัสภายใน</label>
                    <input type="text" name="XVOrderIn" class="form-control text-right" id="" value="{{ old('XVOrderIn', isset($order) ? $order['XVOrderIn'] : 'Autoid') }}" readonly >
                </div>
                <div class="form-group col-md-6">
                    <label for="text">รายละเอียด</label>
                    <input type="text" name="XVOrderDetail" class="form-control text-left" id="" value="{{ old('XVOrderDetail', isset($order) ? $order['XVOrderDetail'] : 'Autoid') }}" readonly >
                </div>
                <div class="form-group col-md-2">
                    <label for="text">โรงฟอก</label>
                    <input type="text" class="form-control"  name="XVBlenchName" id="XVBlenchName" value="{{ old('XVBlenchName', isset($order['XVBlenchName']) ? $order['XVBlenchName'] : '') }}" readonly>
                </div>
            </div><!--end form row-->

            <div  class="row">
                <div class="form-group col-md-2">
                    <label for="text">ค่าฟอก</label>
                    <input type="number" class="form-control text-right"  name="XDOrderBPrince" id="XDOrderBPrince" value="{{ old('XDOrderBPrince', isset($order['XDOrderBPrince']) ? $order['XDOrderBPrince'] : '') }}">
                </div>
            </div>


        </div><!--end card body-->
        <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.setpricebleach.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

               <div class="col text-right">
                <input id="btn_submit" class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
            </div>
          </div>
      </div>
        </form>
    </div><!--end card-->

@endsection


@section('scripts')
<script type="text/javascript">
    $( document ).ready(function() {

        $("#XDOrderBPrince").focus();

        $("#btn_submit").click(function(){
            $("#XCStatus").val(status)
            $("#frm").submit();
        })
    })
</script>

@endsection
