@extends('layouts.admin')
@section('content')

<div class="card">
    {{-- <div class="card-header">
        {{ trans('global.edit') }} {{ trans('global.role.title_singular') }}
    </div> --}}

    <div class="card-body">

        <form action="{{ route("admin.usermenu.update", [$roles->id]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="form-group {{ $errors->has('title') ? 'has-error' : '' }}">
                <label for="title">{{ trans('global.role.fields.title') }}*</label>
                <input type="text" id="title" name="title" class="form-control" value="{{ old('title', $roles->title) }}" readonly>
                @if($errors->has('title'))
                    <em class="invalid-feedback">
                        {{ $errors->first('title') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.role.fields.title_helper') }}
                </p>
            </div>


            <div class="form-group {{ $errors->has('users') ? 'has-error' : '' }}">
                <label for="users">Users*
                    <span class="btn btn-info btn-xs select-all">Select all</span>
                    <span class="btn btn-info btn-xs deselect-all">Deselect all</span></label>

                <select name="users[]" id="users" class="form-control select2" multiple="multiple">
                    @foreach($users as $id)
                    <option value="{{ $id->id }}" {{isset($role_user) && $role_user->contains('user_id',$id->id) ? 'selected' : '' }}>
                            {{ $id->name }}
                        </option>
                    @endforeach
                </select>

            </div>
            <div>
                <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
            </div>
        </form>
    </div>
</div>

@endsection
