<?php


$dev_url = env('APP_URL', 'http://192.168.44.3/vk/public');

Route::redirect('/', $dev_url . '/login');

Route::redirect('/home', $dev_url . '/admin');

//Change language
Route::get('lang/{locale}', function ($locale) {
    App::setLocale($locale);
    Session::put('locale', $locale);
    return redirect()->back();
})->name('lang');

Auth::routes(['register' => false]);

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'Admin', 'middleware' => ['auth']], function () {
    Route::get('/', 'HomeController@index')->name('home');

    Route::delete('permissions/destroy', 'PermissionsController@massDestroy')->name('permissions.massDestroy');
    Route::resource('permissions', 'PermissionsController');

    Route::delete('roles/destroy', 'RolesController@massDestroy')->name('roles.massDestroy');
    Route::get('roles', 'RolesController@index')->name('roles.index');
    Route::resource('roles', 'RolesController');


    Route::delete('users/destroy', 'UsersController@massDestroy')->name('users.massDestroy');
    Route::resource('users', 'UsersController');

    Route::delete('products/destroy', 'ProductsController@massDestroy')->name('products.massDestroy');
    Route::resource('products', 'ProductsController');

    // main customer
    Route::delete('customer/destroy', 'CustomerController@massDestroy')->name('customer.massDestroy');
    Route::resource('customer', 'CustomerController');

    // main shape
    Route::delete('shape/destroy', 'ShapeController@massDestroy')->name('shape.massDestroy');
    Route::resource('shape', 'ShapeController');

    // main for
    Route::delete('foruse/destroy', 'ForuseController@massDestroy')->name('foruse.massDestroy');
    Route::resource('foruse', 'ForuseController');

    //main sewinglocation
    Route::delete('sewinglocatin/destroy', 'SewinglocatinController@massDestroy')->name('sewinglocatin.massDestroy');
    Route::resource('sewinglocatin', 'SewinglocatinController');


    //main totalsewinglocation
    Route::delete('totalsewinglocatin/destroy', 'TotalsewinglocatinController@massDestroy')->name('totalsewinglocatin.massDestroy');
    Route::resource('totalsewinglocatin', 'TotalsewinglocatinController');


    //main formwashcloth
    Route::delete('blench/destroy', 'BlenchController@massDestroy')->name('blench.massDestroy');
    Route::resource('blench', 'BlenchController');

    //main branch
    Route::delete('branch/destroy', 'BranchController@massDestroy')->name('branch.massDestroy');
    Route::resource('branch', 'BranchController');

    //main AccGroup
    Route::delete('accgroup/destroy', 'AccGroupController@massDestroy')->name('accgroup.massDestroy');
    Route::resource('accgroup', 'AccGroupController');

    // main form
    Route::delete('form/destroy', 'FormController@massDestroy')->name('form.massDestroy');
    Route::resource('form', 'FormController');

    // Crate Oder
    Route::resource('order', 'OrderController');

    Route::delete('order/destroy', 'OrderController@massDestroy')->name('order.massDestroy');
    Route::get('order/approve/{id}', 'OrderController@getApprove')->name('order.getApprove');
    Route::any('order/del/{id}', 'OrderController@destroy')->name('order.destroy');


    //main layout
    Route::get('layout', 'LayoutController@index')->name('layout');
    Route::get('layout/create', 'LayoutController@create')->name('layout.create');
    Route::get('layout/id/edit', 'LayoutController@edit')->name('layout.id.edit');

    // main cloth
    Route::get('cloth', 'ClothController@index')->name('cloth');
    Route::get('cloth/create', 'ClothController@create')->name('cloth.create');
    Route::get('cloth/id/edit', 'ClothController@edit')->name('cloth.id.edit');

    // main labelsize
    Route::get('labelsize', 'LabelSizeController@index')->name('labelsize');
    Route::get('labelsize/create', 'LabelSizeController@create')->name('labelsize.create');
    Route::get('labelsize/id/edit', 'LabelSizeController@edit')->name('labelsize.id.edit');

    // main studs
    Route::get('studs', 'StudsController@index')->name('studs');
    Route::get('studs/create', 'StudsController@create')->name('studs.create');
    Route::get('studs/id/edit', 'StudsController@edit')->name('studs.id.edit');

    // main pack
    Route::get('pack', 'PackController@index')->name('pack');
    Route::get('pack/create', 'PackController@create')->name('pack.create');
    Route::get('pack/id/edit', 'PackController@edit')->name('pack.id.edit');

    // main labelname
    Route::get('labelname', 'LabelNameController@index')->name('labelname');
    Route::get('labelname/create', 'LabelNameController@create')->name('labelname.create');
    Route::get('labelname/id/edit', 'LabelNameController@edit')->name('labelname.id.edit');

    // main labelshape
    Route::get('labelshape', 'LabelShapeController@index')->name('labelshape');
    Route::get('labelshape/create', 'LabelShapeController@create')->name('labelshape.create');
    Route::get('labelshape/id/edit', 'LabelShapeController@edit')->name('labelshape.id.edit');

    // main brandzip
    Route::get('brandzip', 'BrandZipController@index')->name('brandzip');
    Route::get('brandzip/create', 'BrandZipController@create')->name('brandzip.create');
    Route::get('brandzip/id/edit', 'BrandZipController@edit')->name('brandzip.id.edit');

    //main zipsize
    Route::get('zipsize', 'ZipSizeController@index')->name('zipsize');
    Route::get('zipsize/create', 'ZipSizeController@create')->name('zipsize.create');
    Route::get('zipsize/id/edit', 'ZipSizeController@edit')->name('zipsize.id.edit');

    //main threadcolor
    Route::get('threadcolor', 'ThreadColorController@index')->name('Threadcolor');
    Route::get('threadcolor/create', 'ThreadColorController@create')->name('Threadcolor.create');
    Route::get('threadcolor/id/edit', 'ThreadColorController@edit')->name('Threadcolor.id.edit');

    //main TrackColor
    Route::get('TrackColor', 'TrackColorController@index')->name('TrackColor');
    Route::get('TrackColor/create', 'TrackColorController@create')->name('TrackColor.create');
    Route::get('TrackColor/id/edit', 'TrackColorController@edit')->name('TrackColor.id.edit');

    //main buttonholecolor
    Route::get('buttonholecolor', 'ButtonholeColorController@index')->name('buttonholecolor');
    Route::get('buttonholecolor/create', 'ButtonholeColorController@create')->name('buttonholecolor.create');
    Route::get('buttonholecolor/id/edit', 'ButtonholeColorController@edit')->name('buttonholecolor.id.edit');

    //main waistSize
    Route::get('waistsize', 'WaistSizeController@index')->name('waistsize');
    Route::get('waistsize/create', 'WaistSizeController@create')->name('waistsize.create');
    Route::get('waistsize/id/edit', 'WaistSizeController@edit')->name('waistsize.id.edit');

    //main sewingstyle
    Route::get('sewingstyle', 'SewingStyleController@index')->name('sewingstyle');
    Route::get('sewingstyle/create', 'SewingStyleController@create')->name('sewingstyle.create');
    Route::get('sewingstyle/id/edit', 'SewingStyleController@edit')->name('sewingstyle.id.edit');

    //main washclothplace
    Route::get('washclothplace', 'WashClothPlaceController@index')->name('washclothplace');
    Route::get('washclothplace/create', 'WashClothPlaceController@create')->name('washclothplace.create');
    Route::get('washclothplace/id/edit', 'WashClothPlaceController@edit')->name('washclothplace.id.edit');

    //main embroideryPlace
    Route::get('embroideryplace', 'EmbroideryPlaceController@index')->name('embroideryplace');
    Route::get('embroideryplace/create', 'EmbroideryPlaceController@create')->name('embroideryplace.create');
    Route::get('embroideryplace/id/edit', 'EmbroideryPlaceController@edit')->name('embroideryplace.id.edit');

    //main examplePlace
    Route::get('exampleplace', 'ExamplePlaceController@index')->name('exampleplace');
    Route::get('exampleplace/create', 'ExamplePlaceController@create')->name('exampleplace.create');
    Route::get('exampleplace/id/edit', 'ExamplePlaceController@edit')->name('exampleplace.id.edit');

    //main supplier
    Route::get('supplier', 'SupplierController@index')->name('supplier');
    Route::get('supplier/create', 'SupplierController@create')->name('supplier.create');
    Route::get('supplier/id/edit', 'SupplierController@edit')->name('supplier.id.edit');

    //main productGroup
    Route::get('productgroup', 'ProductGroupController@index')->name('productgroup');
    Route::get('productgroup/create', 'ProductGroupController@create')->name('productgroup.create');
    Route::get('productgroup/id/edit', 'ProductGroupController@edit')->name('productgroup.id.edit');

    //main typecloth
    Route::get('typecloth', 'TypeClothController@index')->name('typecloth');
    Route::get('typecloth/create', 'TypeClothController@create')->name('typecloth.create');
    Route::get('typecloth/id/edit', 'TypeClothController@edit')->name('typecloth.id.edit');

    //main specmeasurement
    Route::get('specmeasurement', 'SpecMeasurementController@index')->name('specmeasurement');
    Route::get('specmeasurement/create', 'SpecMeasurementController@create')->name('specmeasurement.create');
    Route::get('specmeasurement/id/edit', 'SpecMeasurementController@edit')->name('specmeasurement.id.edit');

    //main transport
    // Route::get('transport', 'TransportController@index')->name('transport');
    // Route::get('transport/create', 'TransportController@create')->name('transport.create');
    // Route::get('transport/id/edit', 'TransportController@edit')->name('transport.id.edit');

    //main categorymaterail
    Route::get('categorymaterail', 'CategoryMaterailController@index')->name('categorymaterail');
    Route::get('categorymaterail/create', 'CategoryMaterailController@create')->name('categorymaterail.create');
    Route::get('categorymaterail/id/edit', 'CategoryMaterailController@edit')->name('categorymaterail.id.edit');

    //main material
    Route::get('material', 'MaterialController@index')->name('material');
    Route::get('material/create', 'MaterialController@create')->name('material.create');
    Route::get('material/id/edit', 'MaterialController@edit')->name('material.id.edit');

    //main section
    Route::get('section', 'SectionController@index')->name('section');
    Route::get('section/create', 'SectionController@create')->name('section.create');
    Route::get('section/id/edit', 'SectionController@edit')->name('section.id.edit');

    //main user
    Route::get('user', 'UserController@index')->name('user');
    Route::get('user/create', 'UserController@create')->name('user.create');
    Route::get('user/id/edit', 'UserController@edit')->name('user.id.edit');

    ## Menu QC
    Route::get('scannotpass ', 'QcController@scanNotPass')->name('qcscanNotPass');



    //MENU แผกฟอก ->Scan รับงานฟอก(scanforbleachingjobs)
    Route::resource('scanforbleachingjobs', 'ScanForBleachingJobsController');
    Route::any('scanforbleachingjobs/create', 'ScanForBleachingJobsController@createData');
    Route::any('scanforbleachingjobsGetData', 'ScanForBleachingJobsController@getData');
    Route::any('scanforbleachingjobsupdate', 'ScanForBleachingJobsController@update');

    //MENU แผกฟอก ->Scan ส่งงานฟอก(scansendbleach)
    Route::resource('scansendbleach', 'ScanSendBleachController');
    Route::get('scansendbleachReport', 'ScanSendBleachController@report')->name('scansendbleachReport');
    Route::post('scansendbleachReportPdf', 'ScanSendBleachController@reportPdf')->name('scansendbleachReportPdf');
    Route::any('ScanSendBleachController', 'ScanSendBleachController@update');
    Route::get('scansendbleachSendReport', 'ScanSendBleachController@sendReport')->name('scansendbleachSendReport');
    Route::post('scansendbleachSendReportPdf', 'ScanSendBleachController@SendreportPdf')->name('scansendbleachSendReportPdf');
    Route::get('reportBalance', 'ScanSendBleachController@reportBalance')->name('reportBalance');
    Route::get('reportBalanceDetail/{docno}/{sizecode}', 'ScanSendBleachController@reportBalanceDetail')->name('reportBalanceDetail');


    //MENU แผนกรับสินค้า ->Scan Stock FG(scanstockfg)
    Route::resource('scanstockfg', 'ScanStockFGController');
    Route::get('scanstockfgReport', 'ScanStockFGController@Report')->name('scanstockfgReport');
    Route::post('scanstockfgReportPdf', 'ScanStockFGController@reportPdf')->name('scanstockfgReportPdf');
    Route::any('ScanStockFGController', 'ScanStockFGController@update');
    Route::get('scanstokOHReport', 'ScanStockFGController@stockOnhandReport')->name('scanstokOHReport');
    Route::post('scanstockOHReportPdf', 'ScanStockFGController@stockOnhandReportPdf')->name('scanstockOHReportPdf');

    //MENU แผนก QC ->Scan สินค้าไม่ผ่าน QC(cannotscanproductviaqc)
    Route::resource('cannotscanproductviaqc', 'CannotScanProdViaQcController');
    Route::any('cannotscanproductviaqcUpdate', 'CannotScanProdViaQcController@update');
    Route::any('cannotscanproductviaqcScan', 'CannotScanProdViaQcController@scanBarcode');

    Route::get('cannotscanproductviaqcReport', 'CannotScanProdViaQcController@report')->name('cannotscanproductviaqcReport');
    Route::post('cannotscanproductviaqcReportPdf', 'CannotScanProdViaQcController@reportPdf')->name('cannotscanproductviaqcReportPdf');
    Route::get('cannotscanproductviaqcRepairReport', 'CannotScanProdViaQcController@RepairReport')->name('cannotscanproductviaqcRepairReport');
    Route::post('cannotscanproductviaqcRepairReportPdf', 'CannotScanProdViaQcController@RepairReportPdf')->name('cannotscanproductviaqcRepairReportPdf');
    Route::get('cannotscanproductviaqcRejectReport', 'CannotScanProdViaQcController@RejectReport')->name('cannotscanproductviaqcRejectReport');
    Route::post('cannotscanproductviaqcRejectReportPdf', 'CannotScanProdViaQcController@RejectReportPdf')->name('cannotscanproductviaqcRejectReportPdf');

    // MENU แผนก QC ->Scan เข้า
    Route::resource('scanQCReceive', 'ScanQCReceiveController');
    Route::get('scanQCReceive/create', 'ScanQCReceiveController@create');
    Route::post('scanQCReceiveGetData', 'ScanQCReceiveController@getData');
    Route::post('scanQCReceiveUpdate', 'ScanQCReceiveController@update');
    Route::get('scanQCReceiveReport', 'ScanQCReceiveController@report')->name('scanQCReceiveReport');
    Route::post('scanQCReceiveReportPdf', 'ScanQCReceiveController@reportPdf')->name('scanQCReceiveReportPdf');
    //MENU แผนก QC ->Scan เมื่อซ่อมเสร็จ(scanproductrepair)
    Route::resource('scanproductrepair', 'ScanProdRepaieController');
    Route::any('ScanProdRepaieController', 'ScanProdRepaieController@update');
    //MENU แผนก QC ->หน้าจอ รูปตำหนิ แต่ละอุปกรณ์(picturedefective)
    Route::resource('picturedefective', 'PicturedeFectiveController');
    Route::any('picturedefective/del/{SeqNo}/{DocNo}', 'PicturedeFectiveController@delete_file');


    //MENU แผนก QC ->รายงาน การรับเข้า QC (admissionsqc)
    Route::resource('admissionsqc', 'AdmissionsQcController');

    //MENU แผนก Packking ->Scan รับเข้า Packking(scanpackking)
    Route::resource('scanpackking', 'ScanPackkingController');
    Route::any('ScanPackkingController', 'ScanPackkingController@update');

    //MENU เบิก-จ่ายอุปกรณ์ ->Barcode(barcode)
    Route::resource('barcode', 'BarcodeController');
    Route::any('BarcodeGetData', 'BarcodeController@getData');
    Route::get('barcode/create', 'BarcodeController@create')->name('barcode.create');
    Route::get('barcode/id/edit', 'BarcodeController@edit')->name('barcode.id.edit');
    Route::get('barcodeExport/{docNo}', 'BarcodeController@export')->name('barcodeExport');


    //MENU เบิก-จ่ายอุปกรณ์ ->Stock อุปกรณ์(stockequipment)
    Route::resource('stockequipment', 'StockEquipmentController');
    // Route::get('stockequipment/create', 'StockEquipmentController@create')->name('stockequipment.create');
    // Route::get('stockequipment/id/edit', 'StockEquipmentController@edit')->name('stockequipment.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->อุปกรณ์การผลิต ผูกกับ Order(equipmentmorder)
    Route::resource('equipmentmorder', 'EquipMentmOrderController');
    Route::get('equipmentmorder/create', 'EquipMentmOrderController@create')->name('equipmentmorder.create');
    Route::get('equipmentmorder/id/edit', 'EquipMentmOrderController@edit')->name('equipmentmorder.id.edit');
    Route::get('equipmentmorder/approve/{id}', 'EquipMentmOrderController@getApprove')->name('equipmentmorder.getApprove');
    // Route::resource('equipmentmorder/fetch', 'EquipMentmOrderController');
    // Route::get('equipmentmorder/fetch', 'EquipMentmOrderController@fetch')->name('equipmentmorder.fetch');
    Route::get('equipmentmorder/fetch2', 'EquipMentmOrderController@fetch2')->name('equipmentmorder.fetch2');
    Route::any('equipmentmorder/test2', 'EquipMentmOrderController@test2')->name('equipmentmorder.test2');

    // Route::delete('order/destroy', 'OrderController@massDestroy')->name('order.massDestroy');
    // Route::get('order/approve/{id}', 'OrderController@getApprove')->name('order.getApprove');
    // Route::any('order/del/{id}', 'OrderController@destroy')->name('order.destroy');

    //MENU เบิก-จ่ายอุปกรณ์ ->จ่ายอุปกรณ์การผลิต(payequipmentm)
    Route::resource('payequipmentm', 'PayEquipMentmController');
    Route::delete('payequipmentm/destroy', 'PayEquipMentmController@massDestroy')->name('payequipmentm.massDestroy');
    Route::any('payequipmentm/approve/{id}/{bc?}', 'PayEquipMentmController@getApprove')->name('payequipmentm.getApprove');
    Route::any('payequipmentm/get_blench/{bc}', 'PayEquipMentmController@order');
    // Route::get('payequipmentmorder/{id}', 'PayEquipMentmController@order')->name('payequipmentmorder.order');
    //Route::get('payequipmentmorder', 'PayEquipMentmController@order');
    Route::any('payequipmentm/del/{id}', 'PayEquipMentmController@destroy')->name('payequipmentm.destroy');


    // Route::get('payequipmentm/create/{id}', 'PayEquipMentmController@getcreate')->name('payequipmentm.getcreate');
    // Route::get('payequipmentm/id/edit', 'PayEquipMentmController@edit')->name('payequipmentm.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->รับอุปกรณ์(pickupequipment)
    Route::resource('pickupequipment', 'PickupEquipMentController');
    // Route::get('pickupequipment', 'PickupEquipMentController@index')->name('pickupequipment');
    Route::get('pickupequipment/create', 'PickupEquipMentController@create')->name('pickupequipment.create');
    Route::get('pickupequipment/id/edit', 'PickupEquipMentController@edit')->name('pickupequipment.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->ลงรับอุปกรณ์ซ่อม(pickupequipmentrepair)
    Route::resource('bigrepairequipment', 'BigRepairEquipmentController');
    // Route::get('bigrepairequipment', 'BigRepairEquipmentController@index')->name('bigrepairequipment');
    Route::get('bigrepairequipment/create', 'BigRepairEquipmentController@create')->name('bigrepairequipment.create');
    Route::get('bigrepairequipment/id/edit', 'BigRepairEquipmentController@edit')->name('bigrepairequipment.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->รายงานอุปกรณ์(equipmentreport)
    // Route::get('equipmentReport', 'EquipMentReportController@index')->name('equipmentReport');
    Route::resource('equipmentReport', 'EquipMentReportController');
    Route::post('equipmentReportPdf', 'EquipMentReportController@reportPdf')->name('equipmentReportPdf');

    //MENU เบิก-จ่ายอุปกรณ์ ->รายงานการเบิกอุปกรณ์(reamequipmentreport)
    Route::resource('reamequipmentReport', 'ReamEquipMentReportController');
    Route::post('reamequipmentReportPdf', 'ReamEquipMentReportController@reportPdf')->name('reamequipmentReportPdf');

    //MENU เบิก-จ่ายอุปกรณ์ ->กำหนดราคางานฟอก(priceworkbleach)
    Route::resource('priceworkbleach', 'PriceWorkBleachController');
    Route::get('priceworkbleach/create', 'PriceWorkBleachController@create')->name('priceworkbleach.create');
    Route::get('priceworkbleach/approve/{id}', 'PriceWorkBleachController@getApprove')->name('priceworkbleach.getApprove');


    // Route::post('reamequipmentReportPdf', 'ReamEquipMentReportController@reportPdf')->name('reamequipmentReportPdf');

    //MENU แผนก QC ->รายงานการส่งซ่อม(sendrepairreport)
    Route::resource('sendrepairReport', 'SendRepairReportController');
    Route::post('sendrepairReportPdf', 'SendRepairReportController@reportPdf')->name('sendrepairReportPdf');

    //MENU แผนก QC ->รายงานการซ่อมเสร็จ(repaircompletedreport)
    Route::resource('repaircompletedreport', 'RepairCompletedReportController');
    Route::post('repaircompletedReportPdf', 'RepairCompletedReportController@reportPdf')->name('repaircompletedReportPdf');

    //MENU แผนก QC ->รายงาน Reject Stock(rejectstockreport)
    Route::resource('rejectstockreport', 'RejectStockReportController');
    Route::post('rejectstockReportPdf', 'RejectStockReportController@reportPdf')->name('rejectstockReportPdf');
    //MENU เบิก-จ่ายอุปกรณ์ ->รายงานอุปกรณ์(reportequipment)
    Route::get('reportequipment', 'reportequipmentController@index')->name('reportequipment');
    // Route::get('reportequipment/create', 'reportequipmentController@create')->name('reportequipment.create');
    // Route::get('reportequipment/id/edit', 'reportequipmentController@edit')->name('reportequipment.id.edit');


    //MENU แผนก Packking ->รายงานการจัดส่ง(deliveryreport)
    Route::resource('deliveryreport', 'DeliveryReportController');
    Route::any('DeliveryReportController', 'DeliveryReportController@update');

    //MENU แผนก Packking ->Scan สินค้าลงกล่อง(scanproductinbox)
    Route::resource('scanproductinbox', 'ScanProductInBoxController');
    // Route::any('ScanProductInBoxController', 'ScanProductInBoxController@update');
    Route::get('scanproductinboxCreate/{boxno?}', 'ScanProductInBoxController@create');
    Route::any('scanproductinboxGetData', 'ScanProductInBoxController@getData');
    Route::post('scanproductinboxGetByBox', 'ScanProductInBoxController@GetByBox');
    Route::post('scanproductinboxUpdate', 'ScanProductInBoxController@update');
    Route::post('scanproductinboxDel', 'ScanProductInBoxController@Delete');
    Route::any('scanproductinboxGetitem/{boxcode}/{sizecode}/{itemno}/{desc}', 'ScanProductInBoxController@edit');


    //MENU แผนก Packking -> Scan เพื่อจัดส่ง(scantransport)
    Route::resource('scantransport', 'ScanTransportController');
    // Route::any('ScanTransportController', 'ScanTransportController@update');
    // Route::get('scantransport/create', 'ScanTransportController@create');
    Route::any('scantransportGetData', 'ScanTransportController@getData');
    Route::post('scantransportUpdate', 'ScanTransportController@update');
    Route::post('scantransportGetByCar', 'ScanTransportController@GetByCar');
    Route::post('scantransportDel', 'ScanTransportController@Delete');
    // Route::get('scantransportReport', 'ScanTransportController@report')->name('scantransportReport');
    // Route::post('scantransportReportPdf', 'ScanTransportController@reportPdf')->name('scantransportReportPdf');

    //MENU แผนก Packking -> รายงาน StockOnHand (ReportStockOnHand)
    Route::resource('reportstockonhand', 'ReportStockOnHandController');

    //MENU แผนก Packking -> รายงานสินค้าลงกล่อง (ReportProductInBox)
    Route::resource('reportproductinbox', 'ReportProductInBoxController');
    Route::any('reportproductinboxGetData', 'ReportProductInBoxController@getData');
    Route::get('reportproductinboxDetail/{boxCode}', 'ReportProductInBoxController@getDataDetail');


    //MENU แผนก Packking -> รายงานการจัดส่ง (reportdelivery)
    Route::resource('reportdelivery', 'ReportDeliveryController');
    Route::post('reportdeliveryGetData', 'ReportDeliveryController@getData');
    Route::get('reportdeliveryDetail/{carCode}/{boxCode}', 'ReportDeliveryController@getDataDetail');

    //MENU แผนก แผนกบัญชี -> ตรวจรับการจัดส่ง (checkdelivery)
    Route::resource('checkdelivery', 'CheckDeliveryController');
    Route::post('checkdeliveryGetData', 'CheckDeliveryController@getData');
    Route::get('checkdeliveryDetail/{carCode}/{boxCode}', 'CheckDeliveryController@getDataDetail');
    Route::any('reportCheckDelivery', 'CheckDeliveryController@getDataReport')->name('reportCheckDelivery');
    Route::any('reportCheckDeliveryDetail/{carCode}/{boxCode}', 'CheckDeliveryController@getDataReportDetail')->name('reportCheckDeliveryDetail');


    //MENU แผนก แผนกบัญชี -> รายงานตรวจรับการจัดส่ง (reportdeliveryacc)
    Route::resource('reportdeliveryacc', 'ReportDeliveryAccController');

    //MENUเมนู RTV -> Scan รับเข้า Stock RTV (scanstockrtv)
    Route::resource('scanstockrtv', 'ScanStockRtvController');
    Route::any('ScanStockRtvController', 'ScanStockRtvController@update');

    //MENUเมนู RTV -> Scan รับเข้า Stock OH (scanstockoh)
    Route::resource('scanstockoh', 'ScanStockOhController');
    Route::any('ScanStockOhController', 'ScanStockOhController@update');

    //MENUเมนู RTV -> RTV To Stock OH (rtvtostockoh)
    Route::resource('rtvtostockoh', 'RtvToStockohController');

    //MENUเมนู RTV -> รายงาน Stock RTV  (reportstockrtv)
    Route::resource('reportstockrtv', 'ReportStockRTVController');

    //MENUเมนู RTV -> รายงาน Stock (ค้าง)   (reportleftoverstock)
    Route::resource('reportleftoverstock', 'ReportLeftoverStockController');

    //MENU แผนก Packking ->รายงานการจัดส่ง(deliveryreport)
    Route::resource('deliveryreport', 'DeliveryReportController');
    Route::any('DeliveryReportController', 'DeliveryReportController@update');

    //** */ ->Import excel เพื่อลงกล่อง(Importexcel)
    // Route::get('Importexcel', function () {
    //     return view('admin.Importexcel');
    // });
    Route::resource('importexcel', 'ImportExcelController');
    Route::post('importexcel/import', 'ImportExcelController@import');
    route::any('importexcelGetData', 'ImportExcelController@getData');


    //MENU รายงาน ->รายงานการส่งงานฟอก(scansendbleachReportadmin)//เจม
    Route::resource('scansendbleachadmin', 'ScansendBleachReporAdminController');
    Route::get('scansendbleachReportadmin', 'ScansendBleachReporAdminController@report')->name('scansendbleachReportadmin');
    Route::post('scansendbleachReportadminPdf', 'ScansendBleachReporAdminController@reportPdf')->name('scansendbleachReportadminPdf');
    Route::any('ScansendBleachReporAdminController', 'ScansendBleachReporAdminController@update');
    Route::get('scansendbleachReportadmin', 'ScansendBleachReporAdminController@sendReport')->name('scansendbleachReportadmin');
    Route::post('scansendbleachReportadminPdf', 'ScansendBleachReporAdminController@SendreportPdf')->name('scansendbleachReportadminPdf');


    //MENU แผนกฟอก ->Scan รับงานฟอก(scanforbleachingjobsadmin)
    Route::resource('scanforbleachingjobsadmin', 'ScanForBleachingJobsAminController');
    Route::any('scanforbleachingjobsadmin/create', 'ScanForBleachingJobsAminController@createData');
    Route::any('scanforbleachingjobsadminGetData', 'ScanForBleachingJobsAminController@getData');
    Route::any('scanforbleachingjobsadminupdate', 'ScanForBleachingJobsAminController@update');



    //MENU แผนกฟอก ->Scan รายงานตาม Order แยกตามโรงฟอก(orderreport)
    Route::get('orderreport', 'OrderReportController@index')->name('orderreport');
    Route::get('orderreport/create', 'OrderReportController@create')->name('orderreport.create');
    Route::get('orderreport/id/edit', 'OrderReportController@edit')->name('orderreport.id.edit');


    //MENU เเผนกบัญชี ->ใบกำกับภาษี (shippingmark)
    Route::resource('shippingmark', 'ShippingMarkController');
    Route::get('shippingmark/create/{XVPONbr}/{XVStoreNbr}', 'ShippingMarkController@createData')->name('shippingmark.createData');
    Route::delete('shippingmark/destroy', 'ShippingMarkController@massDestroy')->name('shippingmark.massDestroy');
    Route::get('shippingmark/approve/{id}', 'ShippingMarkController@getApprove')->name('shippingmark.getApprove');
    Route::any('shippingmark/del/{id}', 'ShippingMarkController@destroy')->name('shippingmark.destroy');


    //แผนกบัญชี -> Import File จัดส่ง(sendimportfile)
    Route::resource('sendimportfile', 'SendImportFileController');
    Route::get('import', 'SendImportFileController@import')->name('import');

    //MENU Planning -> ตรวจสอบ order(checkorder)
    Route::resource('checkorder', 'CheckorderController');
    Route::any('checkorderGetData', 'CheckorderController@getData');
    Route::get('checkorder/create', 'CheckorderController@create')->name('checkorder.create');
    // Route::get('checkorder/id/edit', 'CheckorderController@edit')->name('checkorder.id.edit');
    Route::get('checkorderDetail/{docno}/{sizecode}', 'CheckorderController@edit');

    //MENU แผนกเบิก-จ่าย -> แก้ไข Barcode ติดผิด(editsizebarcode)
    Route::resource('editsizebarcode', 'EditSizeBarcodeController');
    Route::get('editsizebarcode/create', 'EditSizeBarcodeController@create')->name('editsizebarcode.create');
    Route::get('editsizebarcode/id/edit', 'EditSizeBarcodeController@edit')->name('editsizebarcode.id.edit');

    //MENU แผนกเบิก-จ่าย -> กำหนดราคางานฟอก(setpricebleach)
    Route::resource('setpricebleach', 'SetPriceBleachController');
    Route::get('setpricebleach/create', 'SetPriceBleachController@create')->name('setpricebleach.create');
    Route::get('setpricebleach/id/edit', 'SetPriceBleachController@edit')->name('setpricebleach.id.edit');
});
