<?php


$dev_url = env('APP_URL', 'http://vkgarment.dyndns.org/vk/public');

Route::redirect('/', $dev_url . '/login');

Route::redirect('/home', $dev_url . '/admin');

//Change language
Route::get('lang/{locale}', function ($locale) {
    App::setLocale($locale);
    Session::put('locale', $locale);
    return redirect()->back();
})->name('lang');

Auth::routes(['register' => false]);

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'namespace' => 'Admin', 'middleware' => ['auth']], function () {

    Route::get('/', 'HomeController@index')->name('home');
    Route::get('/show/type/{id}', 'HomeController@show_data_type');
    Route::get('/getdata/type', 'HomeController@get_data_type');
    Route::get('/show/tbox', 'HomeController@show_qty_box');
    Route::get('/getdata/qtybox', 'HomeController@get_qty_box');


    Route::resource('dashboard', 'DashboardController');

    Route::delete('permissions/destroy', 'PermissionsController@massDestroy')->name('permissions.massDestroy');
    Route::resource('permissions', 'PermissionsController');

    Route::delete('roles/destroy', 'RolesController@massDestroy')->name('roles.massDestroy');
    Route::get('roles', 'RolesController@index')->name('roles.index');
    Route::resource('roles', 'RolesController');


    Route::delete('users/destroy', 'UsersController@massDestroy')->name('users.massDestroy');
    Route::resource('users', 'UsersController');

    Route::delete('products/destroy', 'ProductsController@massDestroy')->name('products.massDestroy');
    Route::resource('products', 'ProductsController');

    // main customer
    Route::delete('customer/destroy', 'CustomerController@massDestroy')->name('customer.massDestroy');
    Route::resource('customer', 'CustomerController');

    // main shape
    Route::delete('shape/destroy', 'ShapeController@massDestroy')->name('shape.massDestroy');
    Route::resource('shape', 'ShapeController');

    // main for
    Route::delete('foruse/destroy', 'ForuseController@massDestroy')->name('foruse.massDestroy');
    Route::resource('foruse', 'ForuseController');

    //main sewinglocation
    Route::delete('sewinglocatin/destroy', 'SewinglocatinController@massDestroy')->name('sewinglocatin.massDestroy');
    Route::resource('sewinglocatin', 'SewinglocatinController');


    //main totalsewinglocation
    Route::delete('totalsewinglocatin/destroy', 'TotalsewinglocatinController@massDestroy')->name('totalsewinglocatin.massDestroy');
    Route::resource('totalsewinglocatin', 'TotalsewinglocatinController');


    //main formwashcloth
    Route::delete('blench/destroy', 'BlenchController@massDestroy')->name('blench.massDestroy');
    Route::resource('blench', 'BlenchController');

    //main branch
    Route::delete('branch/destroy', 'BranchController@massDestroy')->name('branch.massDestroy');
    Route::resource('branch', 'BranchController');

    //main AccGroup
    Route::delete('accgroup/destroy', 'AccGroupController@massDestroy')->name('accgroup.massDestroy');
    Route::resource('accgroup', 'AccGroupController');

    // main form
    Route::delete('form/destroy', 'FormController@massDestroy')->name('form.massDestroy');
    Route::resource('form', 'FormController');

    // Crate Oder
    Route::resource('order', 'OrderController');

    Route::delete('order/destroy', 'OrderController@massDestroy')->name('order.massDestroy');
    Route::get('order/approve/{id}', 'OrderController@getApprove')->name('order.getApprove');
    Route::any('order/del/{id}', 'OrderController@destroy')->name('order.destroy');
    //ตาล
    Route::any('ordergetdata', 'OrderController@getdata');
    // Route::any('ordergetdata2', 'OrderController@getdata2');
    Route::any('order/create', 'OrderController@create')->name('order.create');
    Route::any('order/create2/{id}', 'OrderController@create2');
    Route::any('order/store', 'OrderController@store')->name('order.store');
    Route::any('order/edit/{id}', 'OrderController@edit');
    Route::any('order/update/{id}', 'OrderController@update')->name('order.update');
    Route::any('order/dele/{id}', 'OrderController@dele')->name('order.dele');
    // Route::any('order/report', 'OrderController@report2')->name('order.report');
    // Route::any('order/reportpdf', 'OrderController@reportpdf')->name('order.reportpdf');


    //main layout
    Route::get('layout', 'LayoutController@index')->name('layout');
    Route::get('layout/create', 'LayoutController@create')->name('layout.create');
    Route::get('layout/id/edit', 'LayoutController@edit')->name('layout.id.edit');

    // main cloth
    Route::get('cloth', 'ClothController@index')->name('cloth');
    Route::get('cloth/create', 'ClothController@create')->name('cloth.create');
    Route::get('cloth/id/edit', 'ClothController@edit')->name('cloth.id.edit');

    // main labelsize
    Route::get('labelsize', 'LabelSizeController@index')->name('labelsize');
    Route::get('labelsize/create', 'LabelSizeController@create')->name('labelsize.create');
    Route::get('labelsize/id/edit', 'LabelSizeController@edit')->name('labelsize.id.edit');

    // main studs
    Route::get('studs', 'StudsController@index')->name('studs');
    Route::get('studs/create', 'StudsController@create')->name('studs.create');
    Route::get('studs/id/edit', 'StudsController@edit')->name('studs.id.edit');

    // main pack
    Route::get('pack', 'PackController@index')->name('pack');
    Route::get('pack/create', 'PackController@create')->name('pack.create');
    Route::get('pack/id/edit', 'PackController@edit')->name('pack.id.edit');

    // main labelname
    Route::get('labelname', 'LabelNameController@index')->name('labelname');
    Route::get('labelname/create', 'LabelNameController@create')->name('labelname.create');
    Route::get('labelname/id/edit', 'LabelNameController@edit')->name('labelname.id.edit');

    // main labelshape
    Route::get('labelshape', 'LabelShapeController@index')->name('labelshape');
    Route::get('labelshape/create', 'LabelShapeController@create')->name('labelshape.create');
    Route::get('labelshape/id/edit', 'LabelShapeController@edit')->name('labelshape.id.edit');

    // main brandzip
    Route::get('brandzip', 'BrandZipController@index')->name('brandzip');
    Route::get('brandzip/create', 'BrandZipController@create')->name('brandzip.create');
    Route::get('brandzip/id/edit', 'BrandZipController@edit')->name('brandzip.id.edit');

    //main zipsize
    Route::get('zipsize', 'ZipSizeController@index')->name('zipsize');
    Route::get('zipsize/create', 'ZipSizeController@create')->name('zipsize.create');
    Route::get('zipsize/id/edit', 'ZipSizeController@edit')->name('zipsize.id.edit');

    //main threadcolor
    Route::get('threadcolor', 'ThreadColorController@index')->name('Threadcolor');
    Route::get('threadcolor/create', 'ThreadColorController@create')->name('Threadcolor.create');
    Route::get('threadcolor/id/edit', 'ThreadColorController@edit')->name('Threadcolor.id.edit');

    //main TrackColor
    Route::get('TrackColor', 'TrackColorController@index')->name('TrackColor');
    Route::get('TrackColor/create', 'TrackColorController@create')->name('TrackColor.create');
    Route::get('TrackColor/id/edit', 'TrackColorController@edit')->name('TrackColor.id.edit');

    //main buttonholecolor
    Route::get('buttonholecolor', 'ButtonholeColorController@index')->name('buttonholecolor');
    Route::get('buttonholecolor/create', 'ButtonholeColorController@create')->name('buttonholecolor.create');
    Route::get('buttonholecolor/id/edit', 'ButtonholeColorController@edit')->name('buttonholecolor.id.edit');

    //main waistSize
    Route::get('waistsize', 'WaistSizeController@index')->name('waistsize');
    Route::get('waistsize/create', 'WaistSizeController@create')->name('waistsize.create');
    Route::get('waistsize/id/edit', 'WaistSizeController@edit')->name('waistsize.id.edit');

    //main sewingstyle
    Route::get('sewingstyle', 'SewingStyleController@index')->name('sewingstyle');
    Route::get('sewingstyle/create', 'SewingStyleController@create')->name('sewingstyle.create');
    Route::get('sewingstyle/id/edit', 'SewingStyleController@edit')->name('sewingstyle.id.edit');

    //main washclothplace
    Route::get('washclothplace', 'WashClothPlaceController@index')->name('washclothplace');
    Route::get('washclothplace/create', 'WashClothPlaceController@create')->name('washclothplace.create');
    Route::get('washclothplace/id/edit', 'WashClothPlaceController@edit')->name('washclothplace.id.edit');

    //main embroideryPlace
    Route::get('embroideryplace', 'EmbroideryPlaceController@index')->name('embroideryplace');
    Route::get('embroideryplace/create', 'EmbroideryPlaceController@create')->name('embroideryplace.create');
    Route::get('embroideryplace/id/edit', 'EmbroideryPlaceController@edit')->name('embroideryplace.id.edit');

    //main examplePlace
    Route::get('exampleplace', 'ExamplePlaceController@index')->name('exampleplace');
    Route::get('exampleplace/create', 'ExamplePlaceController@create')->name('exampleplace.create');
    Route::get('exampleplace/id/edit', 'ExamplePlaceController@edit')->name('exampleplace.id.edit');

    //main supplier
    Route::get('supplier', 'SupplierController@index')->name('supplier');
    Route::get('supplier/create', 'SupplierController@create')->name('supplier.create');
    Route::get('supplier/id/edit', 'SupplierController@edit')->name('supplier.id.edit');

    //main productGroup
    Route::get('productgroup', 'ProductGroupController@index')->name('productgroup');
    Route::get('productgroup/create', 'ProductGroupController@create')->name('productgroup.create');
    Route::get('productgroup/id/edit', 'ProductGroupController@edit')->name('productgroup.id.edit');

    //main typecloth
    Route::get('typecloth', 'TypeClothController@index')->name('typecloth');
    Route::get('typecloth/create', 'TypeClothController@create')->name('typecloth.create');
    Route::get('typecloth/id/edit', 'TypeClothController@edit')->name('typecloth.id.edit');

    //main specmeasurement
    Route::get('specmeasurement', 'SpecMeasurementController@index')->name('specmeasurement');
    Route::get('specmeasurement/create', 'SpecMeasurementController@create')->name('specmeasurement.create');
    Route::get('specmeasurement/id/edit', 'SpecMeasurementController@edit')->name('specmeasurement.id.edit');

    //main transport
    // Route::get('transport', 'TransportController@index')->name('transport');
    // Route::get('transport/create', 'TransportController@create')->name('transport.create');
    // Route::get('transport/id/edit', 'TransportController@edit')->name('transport.id.edit');

    //main categorymaterail
    Route::get('categorymaterail', 'CategoryMaterailController@index')->name('categorymaterail');
    Route::get('categorymaterail/create', 'CategoryMaterailController@create')->name('categorymaterail.create');
    Route::get('categorymaterail/id/edit', 'CategoryMaterailController@edit')->name('categorymaterail.id.edit');

    //main material
    Route::get('material', 'MaterialController@index')->name('material');
    Route::get('material/create', 'MaterialController@create')->name('material.create');
    Route::get('material/id/edit', 'MaterialController@edit')->name('material.id.edit');

    //main section
    Route::get('section', 'SectionController@index')->name('section');
    Route::get('section/create', 'SectionController@create')->name('section.create');
    Route::get('section/id/edit', 'SectionController@edit')->name('section.id.edit');

    //main user
    Route::get('user', 'UserController@index')->name('user');
    Route::get('user/create', 'UserController@create')->name('user.create');
    Route::get('user/id/edit', 'UserController@edit')->name('user.id.edit');

    ## Menu QC
    Route::get('scannotpass ', 'QcController@scanNotPass')->name('qcscanNotPass');



    //MENU แผกฟอก ->Scan รับงานฟอก(scanforbleachingjobs)
    Route::resource('scanforbleachingjobs', 'ScanForBleachingJobsController');
    Route::any('scanforbleachingjobs/create', 'ScanForBleachingJobsController@createData');
    Route::any('scanforbleachingjobsupdate', 'ScanForBleachingJobsController@update');
    Route::get('scanstockfg/find/{date}/{size}', 'ScanForBleachingJobsController@stockshowDetail');
    //new
    Route::any('scanforbleachingjobsGetData', 'ScanForBleachingJobsController@getData');
    Route::get('scanforbleachingjobs/detail/{date}/{size}/{orderin}', 'ScanForBleachingJobsController@stockshowDetail');
    Route::get('scanforbleachingjobs/find/detail', 'ScanForBleachingJobsController@stockshowMyDetail');

    //MENU แผกฟอก ->Scan ส่งงานฟอก(scansendbleach)
    Route::resource('scansendbleach', 'ScanSendBleachController');
    Route::get('scansendbleachReport', 'ScanSendBleachController@report')->name('scansendbleachReport');
    Route::post('scansendbleachReportPdf', 'ScanSendBleachController@reportPdf')->name('scansendbleachReportPdf');
    Route::any('ScanSendBleachController', 'ScanSendBleachController@update');
    Route::get('scansendbleachSendReport', 'ScanSendBleachController@sendReport')->name('scansendbleachSendReport');
    Route::post('scansendbleachSendReportPdf', 'ScanSendBleachController@SendreportPdf')->name('scansendbleachSendReportPdf');
    Route::get('reportBalance', 'ScanSendBleachController@reportBalance')->name('reportBalance');
    Route::get('reportBalanceDetail/{docno}/{sizecode}', 'ScanSendBleachController@reportBalanceDetail')->name('reportBalanceDetail');
    //new
    Route::any('scansendbleachGetData', 'ScanSendBleachController@getData');
    Route::get('scansendbleach/detail/{date}/{size}/{orderin}', 'ScanSendBleachController@stockshowDetail');
    Route::get('scansendbleach/find/detail', 'ScanSendBleachController@stockshowMyDetail');


    //MENU แผนกรับสินค้า ->Scan Stock FG(scanstockfg)
    Route::resource('scanstockfg', 'ScanStockFGController');
    //Route::resource('scanstockfg', 'ScanStockFGController@showin');
    Route::get('scanstockfgReport', 'ScanStockFGController@Report')->name('scanstockfgReport');
    Route::post('scanstockfgReportPdf', 'ScanStockFGController@reportPdf')->name('scanstockfgReportPdf');
    Route::any('ScanStockFGController', 'ScanStockFGController@update');
    Route::get('scanstokOHReport', 'ScanStockFGController@stockOnhandReport')->name('scanstokOHReport');
    Route::post('scanstockOHReportPdf', 'ScanStockFGController@stockOnhandReportPdf')->name('scanstockOHReportPdf');
    Route::get('scanstockfg/detail/{date}/{size}/{orderin}', 'ScanStockFGController@stockshowDetail');
    Route::any('scanstockfgGetData', 'ScanStockFGController@getData');
    Route::any('scanstockfgGetDataNew', 'ScanStockFGController@getData_new');
    Route::get('scanstockfg/find/detail', 'ScanStockFGController@stockshowMyDetail');
    Route::get('scanstockfg/editDetail/{docno}/{orderin}/{size}/{amount}/{detail}', 'ScanStockFGController@stockshowDetailNew');
    Route::post('scanstockfg/editupdateDetail', 'ScanStockFGController@updateDetailNew');


    //MENU แผนก QC ->Scan สินค้าไม่ผ่าน QC(cannotscanproductviaqc)
    Route::resource('cannotscanproductviaqc', 'CannotScanProdViaQcController');
    Route::any('cannotscanproductviaqcUpdate', 'CannotScanProdViaQcController@update');
    Route::any('cannotscanproductviaqcScan', 'CannotScanProdViaQcController@scanBarcode');

    Route::get('cannotscanproductviaqcReport', 'CannotScanProdViaQcController@report')->name('cannotscanproductviaqcReport');
    Route::post('cannotscanproductviaqcReportPdf', 'CannotScanProdViaQcController@reportPdf')->name('cannotscanproductviaqcReportPdf');
    Route::get('cannotscanproductviaqcRepairReport', 'CannotScanProdViaQcController@RepairReport')->name('cannotscanproductviaqcRepairReport');
    Route::post('cannotscanproductviaqcRepairReportPdf', 'CannotScanProdViaQcController@RepairReportPdf')->name('cannotscanproductviaqcRepairReportPdf');
    Route::get('cannotscanproductviaqcRejectReport', 'CannotScanProdViaQcController@RejectReport')->name('cannotscanproductviaqcRejectReport');
    Route::post('cannotscanproductviaqcRejectReportPdf', 'CannotScanProdViaQcController@RejectReportPdf')->name('cannotscanproductviaqcRejectReportPdf');
    //----new
    Route::get('cannotscanproductviaqc/detail/{date}/{size}/{orderin}', 'CannotScanProdViaQcController@cannotqcshowDetail');
    Route::get('cannotscanproductviaqc/find/detail', 'CannotScanProdViaQcController@cannotqcfindDetail');
    Route::get('cannotscanproductviaqcGetData', 'CannotScanProdViaQcController@getData');


    // MENU แผนก QC ->Scan เข้า
    Route::resource('scanQCReceive', 'ScanQCReceiveController');
    Route::get('scanQCReceive/create', 'ScanQCReceiveController@create');
    Route::post('scanQCReceiveGetData', 'ScanQCReceiveController@getData');
    Route::post('scanQCReceiveUpdate', 'ScanQCReceiveController@update');
    Route::get('scanQCReceiveReport', 'ScanQCReceiveController@report')->name('scanQCReceiveReport');
    Route::post('scanQCReceiveReportPdf', 'ScanQCReceiveController@reportPdf')->name('scanQCReceiveReportPdf');
    //MENU แผนก QC ->Scan เมื่อซ่อมเสร็จ(scanproductrepair)
    Route::resource('scanproductrepair', 'ScanProdRepaieController');
    Route::any('ScanProdRepaieController', 'ScanProdRepaieController@update');
    //MENU แผนก QC ->หน้าจอ รูปตำหนิ แต่ละอุปกรณ์(picturedefective)
    Route::resource('picturedefective', 'PicturedeFectiveController');
    Route::any('picturedefective/del/{SeqNo}/{DocNo}', 'PicturedeFectiveController@delete_file');

    Route::get('scanQCReceive/detail/{date}/{size}/{orderin}', 'ScanQCReceiveController@qcshowDetail');
    Route::get('scanQCReceive/find/detail', 'ScanQCReceiveController@qcfindDetail');


    //MENU แผนก QC ->รายงาน การรับเข้า QC (admissionsqc)
    Route::resource('admissionsqc', 'AdmissionsQcController');

    //MENU แผนก Packking ->Scan รับเข้า Packking(scanpackking)
    Route::resource('scanpackking', 'ScanPackkingController');
    Route::any('ScanPackkingController', 'ScanPscanforbleachingjobsGetDataackkingController@update');
    Route::get('ScanPackkingReport', 'ScanPackkingController@report')->name('ScanPackkingReport');
    Route::post('ScanPackkingReportPdf', 'ScanPackkingController@reportPdf')->name('ScanPackkingReportPdf');
    Route::get('scanpackking/detail/{date}/{size}/{orderin}', 'ScanPackkingController@stockshowDetail');
    Route::any('scanPackkingGetData', 'ScanPackkingController@getData');
    Route::get('scanpackking/find/detail', 'ScanPackkingController@stockshowMyDetail');


    //MENU เบิก-จ่ายอุปกรณ์ ->Barcode(barcode)
    Route::resource('barcode', 'BarcodeController');
    Route::any('BarcodeGetData', 'BarcodeController@getData');
    Route::get('barcode/create', 'BarcodeController@create')->name('barcode.create');
    Route::get('barcode/id/edit', 'BarcodeController@edit')->name('barcode.id.edit');
    Route::get('barcodeExport/{docNo}/{sizecode}', 'BarcodeController@export')->name('barcodeExport');

    //new ส่งงาน
    Route::any('barcode/sendItem','BarcodeController@show')->name('barcode.sendItem');
    Route::any('BarcodeSendItemGetData', 'BarcodeController@SendItemgetData');
    Route::get('barcode/sendItem/confirm/{Docno}/{OrderIn}/{DSize}/{TotalNum}','BarcodeController@showConfirmSendItem');
    Route::post('barcode/sendItem/confirm','BarcodeController@confirmSendItem');

    //New รับงาน
    Route::resource('receiveItem','ReceiveItemController');
    Route::any('receiveItemGetData', 'ReceiveItemController@receiveItemgetData');
    Route::get('receive/receiveItem/confirm/{Docno}/{OrderIn}/{DSize}/{TotalNum}','ReceiveItemController@showConfirmreceiveItem');
    Route::post('receive/receiveItem/confirm','ReceiveItemController@confirmreceiveItem');


    //MENU เบิก-จ่ายอุปกรณ์ ->Stock อุปกรณ์(stockequipment)
    Route::resource('stockequipment', 'StockEquipmentController');
    // Route::get('stockequipment/create', 'StockEquipmentController@create')->name('stockequipment.create');
    // Route::get('stockequipment/id/edit', 'StockEquipmentController@edit')->name('stockequipment.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->อุปกรณ์การผลิต ผูกกับ Order(equipmentmorder)
    Route::resource('equipmentmorder', 'EquipMentmOrderController');
    Route::get('equipmentmorder/create', 'EquipMentmOrderController@create')->name('equipmentmorder.create');
    Route::get('equipmentmorder/id/edit', 'EquipMentmOrderController@edit')->name('equipmentmorder.id.edit');
    Route::get('equipmentmorder/approve/{id}', 'EquipMentmOrderController@getApprove')->name('equipmentmorder.getApprove');
    // Route::resource('equipmentmorder/fetch', 'EquipMentmOrderController');
    // Route::get('equipmentmorder/fetch', 'EquipMentmOrderController@fetch')->name('equipmentmorder.fetch');
    Route::get('equipmentmorder/fetch2', 'EquipMentmOrderController@fetch2')->name('equipmentmorder.fetch2');
    Route::any('equipmentmorder/test2', 'EquipMentmOrderController@test2')->name('equipmentmorder.test2');

    // Route::delete('order/destroy', 'OrderController@massDestroy')->name('order.massDestroy');
    // Route::get('order/approve/{id}', 'OrderController@getApprove')->name('order.getApprove');
    // Route::any('order/del/{id}', 'OrderController@destroy')->name('order.destroy');

    //MENU เบิก-จ่ายอุปกรณ์ ->จ่ายอุปกรณ์การผลิต(payequipmentm)
    Route::resource('payequipmentm', 'PayEquipMentmController');
    Route::delete('payequipmentm/destroy', 'PayEquipMentmController@massDestroy')->name('payequipmentm.massDestroy');
    Route::any('payequipmentm/approve/{id}/{bc?}', 'PayEquipMentmController@getApprove')->name('payequipmentm.getApprove');
    Route::any('payequipmentm/get_blench/{bc}', 'PayEquipMentmController@order');
    // Route::get('payequipmentmorder/{id}', 'PayEquipMentmController@order')->name('payequipmentmorder.order');
    //Route::get('payequipmentmorder', 'PayEquipMentmController@order');
    Route::any('payequipmentm/del/{id}', 'PayEquipMentmController@destroy')->name('payequipmentm.destroy');
    Route::any('payequipmentm/approve/{id}', 'PayEquipMentmController@update')->name('payequipmentm.approve');
    Route::post('payequipmentmUpdate', 'PayEquipMentmController@update');


    // Route::get('payequipmentm/create/{id}', 'PayEquipMentmController@getcreate')->name('payequipmentm.getcreate');
    // Route::get('payequipmentm/id/edit', 'PayEquipMentmController@edit')->name('payequipmentm.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->รับอุปกรณ์(pickupequipment)
    Route::resource('pickupequipment', 'PickupEquipMentController');
    // Route::get('pickupequipment', 'PickupEquipMentController@index')->name('pickupequipment');
    Route::get('pickupequipment/create', 'PickupEquipMentController@create')->name('pickupequipment.create');
    Route::get('pickupequipment/id/edit', 'PickupEquipMentController@edit')->name('pickupequipment.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->ลงรับอุปกรณ์ซ่อม(pickupequipmentrepair)
    Route::resource('bigrepairequipment', 'BigRepairEquipmentController');
    // Route::get('bigrepairequipment', 'BigRepairEquipmentController@index')->name('bigrepairequipment');
    Route::get('bigrepairequipment/create', 'BigRepairEquipmentController@create')->name('bigrepairequipment.create');
    Route::get('bigrepairequipment/id/edit', 'BigRepairEquipmentController@edit')->name('bigrepairequipment.id.edit');

    //MENU เบิก-จ่ายอุปกรณ์ ->รายงานอุปกรณ์(equipmentreport)
    // Route::get('equipmentReport', 'EquipMentReportController@index')->name('equipmentReport');
    Route::resource('equipmentReport', 'EquipMentReportController');
    Route::post('equipmentReportPdf', 'EquipMentReportController@reportPdf')->name('equipmentReportPdf');

    //MENU เบิก-จ่ายอุปกรณ์ ->รายงานการเบิกอุปกรณ์(reamequipmentreport)
    Route::resource('reamequipmentReport', 'ReamEquipMentReportController');
    Route::post('reamequipmentReportPdf', 'ReamEquipMentReportController@reportPdf')->name('reamequipmentReportPdf');

    //MENU เบิก-จ่ายอุปกรณ์ ->กำหนดราคางานฟอก(priceworkbleach)
    Route::resource('priceworkbleach', 'PriceWorkBleachController');
    Route::get('priceworkbleach/create/{id}', 'PriceWorkBleachController@create')->name('priceworkbleach.create');
    Route::get('priceworkbleach/approve/{id}', 'PriceWorkBleachController@getApprove')->name('priceworkbleach.getApprove');
    Route::get('priceworkbleach1', 'PriceWorkBleachController@priceworkbleach')->name('priceworkbleach.priceworkbleach');

    // Route::get('priceworkbleach/{id}/create','PriceWorkBleachController@edit');
    // Route::post('priceworkbleachupdate', 'PriceWorkBleachController@update');
    // Route::post('priceworkbleachupdate', 'PriceWorkBleachController@update')->name('priceworkbleachupdate');

    // Route::post('priceworkbleachupdate', 'PriceWorkBleachController@someMethod');


    // Route::post('reamequipmentReportPdf', 'ReamEquipMentReportController@reportPdf')->name('reamequipmentReportPdf');

    //MENU แผนก QC ->รายงานการส่งซ่อม(sendrepairreport)
    Route::resource('sendrepairReport', 'SendRepairReportController');
    Route::post('sendrepairReportPdf', 'SendRepairReportController@reportPdf')->name('sendrepairReportPdf');

    //MENU แผนก QC ->รายงานการซ่อมเสร็จ(repaircompletedreport)
    Route::resource('repaircompletedreport', 'RepairCompletedReportController');
    Route::post('repaircompletedReportPdf', 'RepairCompletedReportController@reportPdf')->name('repaircompletedReportPdf');

    //MENU แผนก QC ->รายงาน Reject Stock(rejectstockreport)
    Route::resource('rejectstockreport', 'RejectStockReportController');
    Route::post('rejectstockReportPdf', 'RejectStockReportController@reportPdf')->name('rejectstockReportPdf');
    //MENU เบิก-จ่ายอุปกรณ์ ->รายงานอุปกรณ์(reportequipment)
    Route::get('reportequipment', 'reportequipmentController@index')->name('reportequipment');
    // Route::get('reportequipment/create', 'reportequipmentController@create')->name('reportequipment.create');
    // Route::get('reportequipment/id/edit', 'reportequipmentController@edit')->name('reportequipment.id.edit');


    //MENU แผนก Packking ->รายงานการจัดส่ง(deliveryreport)
    Route::resource('deliveryreport', 'DeliveryReportController');
    Route::any('DeliveryReportController', 'DeliveryReportController@update');

    //MENU แผนก Packking ->Scan สินค้าลงกล่อง(scanproductinbox)
    Route::resource('scanproductinbox', 'ScanProductInBoxController');
    // Route::any('ScanProductInBoxController', 'ScanProductInBoxController@update');
    Route::get('scanproductinboxCreate/{boxno?}', 'ScanProductInBoxController@create');
    Route::post('scanproductinboxGetByBox', 'ScanProductInBoxController@GetByBox');
    Route::post('scanproductinboxUpdate', 'ScanProductInBoxController@update');
    Route::post('scanproductinboxDel', 'ScanProductInBoxController@Delete');
    Route::any('scanproductinboxGetitem/{boxcode}/{sizecode}/{itemno}/{desc}', 'ScanProductInBoxController@edit');
    //----new
    Route::get('scanproductinbox/detail/{date}/{size}/{orderin}', 'ScanProductInBoxController@scanproductinboxshowDetail');
    Route::get('scanproductinbox/find/detail', 'ScanProductInBoxController@scanproductinboxfindDetail');
    Route::any('scanproductinboxGetData', 'ScanProductInBoxController@getData');


    //MENU แผนก Packking -> Scan เพื่อจัดส่ง(scantransport)
    Route::resource('scantransport', 'ScanTransportController');
    // Route::any('ScanTransportController', 'ScanTransportController@update');
    // Route::get('scantransport/create', 'ScanTransportController@create');
    Route::post('scantransportUpdate', 'ScanTransportController@update');
    Route::post('scantransportGetByCar', 'ScanTransportController@GetByCar');
    Route::post('scantransportDel', 'ScanTransportController@Delete');
    // Route::get('scantransportReport', 'ScanTransportController@report')->name('scantransportReport');
    // Route::post('scantransportReportPdf', 'ScanTransportController@reportPdf')->name('scantransportReportPdf');
    //----new
    Route::get('scantransport/detail/{date}/{size}/{orderin}', 'ScanTransportController@scantransportshowDetail');
    Route::get('scantransport/find/detail', 'ScanTransportController@scantransportfindDetail');
    Route::any('scantransportGetData', 'ScanTransportController@getData');


    //MENU แผนก Packking -> รายงาน StockOnHand (ReportStockOnHand)
    Route::resource('reportstockonhand', 'ReportStockOnHandController');

    //MENU แผนก Packking -> รายงานสินค้าลงกล่อง (ReportProductInBox)
    Route::resource('reportproductinbox', 'ReportProductInBoxController');
    Route::get('reportproductinboxDetail/{boxCode}', 'ReportProductInBoxController@getDataDetail');
    //----new
    Route::get('reportproductinbox/detail/{date}/{size}/{orderin}', 'ScanTransportController@reportproductinboxshowDetail');
    Route::get('reportproductinbox/find/detail', 'ScanTransportController@reportproductinboxfindDetail');
    Route::any('reportproductinboxGetData', 'ReportProductInBoxController@getData');


    //MENU แผนก Packking -> รายงานการจัดส่ง (reportdelivery)
    Route::resource('reportdelivery', 'ReportDeliveryController');

    Route::get('reportdeliveryDetail/{carCode}/{boxCode}', 'ReportDeliveryController@getDataDetail');
    //----new
    Route::get('reportdelivery/detail/{date}/{size}/{orderin}', 'ReportDeliveryController@reportdeliveryaccshowDetail');
    Route::get('reportdelivery/find/detail', 'ReportDeliveryController@reportdeliveryaccfindDetail');
    Route::post('reportdeliveryGetData', 'ReportDeliveryController@getData');


    //MENU แผนก แผนกบัญชี -> ตรวจรับการจัดส่ง (checkdelivery)
    Route::resource('checkdelivery', 'CheckDeliveryController');
    Route::post('checkdeliveryGetData', 'CheckDeliveryController@getData');
    Route::get('checkdeliveryDetail/{carCode}/{boxCode}', 'CheckDeliveryController@getDataDetail');
    Route::any('reportCheckDelivery', 'CheckDeliveryController@getDataReport')->name('reportCheckDelivery');
    Route::any('reportCheckDeliveryDetail/{carCode}/{boxCode}', 'CheckDeliveryController@getDataReportDetail')->name('reportCheckDeliveryDetail');


    //MENU แผนก แผนกบัญชี -> รายงานตรวจรับการจัดส่ง (reportdeliveryacc)
    Route::resource('reportdeliveryacc', 'ReportDeliveryAccController');

    //MENUเมนู RTV -> Scan รับเข้า Stock RTV (scanstockrtv)
    Route::resource('scanstockrtv', 'ScanStockRtvController');
    Route::any('ScanStockRtvController', 'ScanStockRtvController@update');

    //MENUเมนู RTV -> Scan รับเข้า Stock OH (scanstockoh)
    Route::resource('scanstockoh', 'ScanStockOhController');
    Route::any('ScanStockOhController', 'ScanStockOhController@update');

    //MENUเมนู RTV -> RTV To Stock OH (rtvtostockoh)
    Route::resource('rtvtostockoh', 'RtvToStockohController');

    //MENUเมนู RTV -> รายงาน Stock RTV  (reportstockrtv)
    Route::resource('reportstockrtv', 'ReportStockRTVController');

    //MENUเมนู RTV -> รายงาน Stock (ค้าง)   (reportleftoverstock)
    Route::resource('reportleftoverstock', 'ReportLeftoverStockController');

    //MENU แผนก Packking ->รายงานการจัดส่ง(deliveryreport)
    Route::resource('deliveryreport', 'DeliveryReportController');
    Route::any('DeliveryReportController', 'DeliveryReportController@update');

    //** */ ->Import excel เพื่อลงกล่อง(Importexcel)
    // Route::get('Importexcel', function () {
    //     return view('admin.Importexcel');
    // });
    Route::resource('importexcel', 'ImportExcelController');
    Route::post('importexcel/import', 'ImportExcelController@import');
    route::any('importexcelGetData', 'ImportExcelController@getData');


    // New Brow PO
    // Route::any('importpo', 'ImportCusPOController');
    // route::any('Importcusgetdata', 'ImportCusPOController@getdata2');


    //MENU รายงาน ->รายงานการส่งงานฟอก(scansendbleachReportadmin)//เจม
    Route::resource('scansendbleachadmin', 'ScansendBleachReporAdminController');
    Route::get('scansendbleachReportadmin', 'ScansendBleachReporAdminController@report')->name('scansendbleachReportadmin');
    Route::post('scansendbleachReportadminPdf', 'ScansendBleachReporAdminController@reportPdf')->name('scansendbleachReportadminPdf');
    Route::any('ScansendBleachReporAdminController', 'ScansendBleachReporAdminController@update');
    Route::get('scansendbleachReportadmin', 'ScansendBleachReporAdminController@sendReport')->name('scansendbleachReportadmin');
    Route::post('scansendbleachReportadminPdf', 'ScansendBleachReporAdminController@SendreportPdf')->name('scansendbleachReportadminPdf');


    //MENU แผนกฟอก ->Scan รับงานฟอก(scanforbleachingjobsadmin)
    Route::resource('scanforbleachingjobsadmin', 'ScanForBleachingJobsAminController');
    Route::any('scanforbleachingjobsadmin/create', 'ScanForBleachingJobsAminController@createData');
    Route::any('scanforbleachingjobsadminGetData', 'ScanForBleachingJobsAminController@getData');
    Route::any('scanforbleachingjobsadminupdate', 'ScanForBleachingJobsAminController@update');



    //MENU แผนกฟอก ->Scan รายงานตาม Order แยกตามโรงฟอก(orderreport)
    Route::get('orderreport', 'OrderReportController@index')->name('orderreport');
    Route::get('orderreport/create', 'OrderReportController@create')->name('orderreport.create');
    Route::get('orderreport/id/edit', 'OrderReportController@edit')->name('orderreport.id.edit');


    //MENU เเผนกบัญชี ->ใบกำกับภาษี (shippingmark)
    Route::resource('shippingmark', 'ShippingMarkController');
    Route::get('shippingmark/create/{XVPONbr}/{XVStoreNbr}', 'ShippingMarkController@createData')->name('shippingmark.createData');
    Route::delete('shippingmark/destroy', 'ShippingMarkController@massDestroy')->name('shippingmark.massDestroy');
    Route::get('shippingmark/approve/{id}', 'ShippingMarkController@getApprove')->name('shippingmark.getApprove');
    Route::any('shippingmark/del/{id}', 'ShippingMarkController@destroy')->name('shippingmark.destroy');

    //แผนกบัญชี -> Import File จัดส่ง(sendimportfile)
    Route::get('sendimportfile', 'SendImportFileController@index')->name('admin.sendimportfilexx');
    Route::get('import', 'SendImportFileController@import')->name('import');

    //MENU Planning -> ตรวจสอบ order(checkorder)
    Route::get('/checkorder/checkproduct', 'CheckorderController@product')->name('checkproduct.checkproduct');
    Route::any('/checkorder/checkproduct/GetData', 'CheckorderController@getDataProduct');

    Route::resource('checkorder', 'CheckorderController');
    Route::any('checkorderGetData', 'CheckorderController@getData');
    Route::get('checkorder/create', 'CheckorderController@create')->name('checkorder.create');
    // Route::get('checkorder/id/edit', 'CheckorderController@edit')->name('checkorder.id.edit');
    Route::get('checkorderDetail/{docno}/{sizecode}', 'CheckorderController@edit');

    //MENU แผนกเบิก-จ่าย -> แก้ไข Barcode ติดผิด(editsizebarcode)
    Route::resource('editsizebarcode', 'EditSizeBarcodeController');
    Route::get('editsizebarcode/create', 'EditSizeBarcodeController@create')->name('editsizebarcode.create');
    Route::get('editsizebarcode/id/edit', 'EditSizeBarcodeController@edit')->name('editsizebarcode.id.edit');
    Route::any('editsizebarcodeCheck', 'EditSizeBarcodeController@checkBarcode');
    Route::any('editsizebarcodeUpdateSize', 'EditSizeBarcodeController@updateSize');


    //MENU แผนกเบิก-จ่าย -> กำหนดราคางานฟอก(setpricebleach)
    Route::resource('setpricebleach', 'SetPriceBleachController');
    Route::get('setpricebleach/create', 'SetPriceBleachController@create')->name('setpricebleach.create');
    Route::get('setpricebleach/id/edit', 'SetPriceBleachController@edit')->name('setpricebleach.id.edit');

    //ยืม-คืน
    Route::get('/borrow', 'BorrowController@index')->name('borrow');
    Route::get('/borrow/create', 'BorrowController@create');
    Route::any('/borrow/updateborrow','BorrowController@updateBorrow');
    Route::any('/borrow/checkbarcode','BorrowController@checkBarCode');
    Route::any('/borrow/show','BorrowController@showBarcode');
    Route::any('/borrow/showtable','BorrowController@showTable');
    Route::any('borrow/store', 'BorrowController@store')->name('borrow.store');

    Route::any('/testing','TestingController@index')->name('testing.index');

    // PPE
    Route::get('ppe', 'PpeController@index')->name('ppe');
    Route::any('ppegetdata', 'PpeController@getdata');
    Route::any('ppe/create', 'PpeController@create');
    Route::get('ppe/edit/{id}', 'PpeController@edit');
    Route::put('ppe/update/{id}', 'PpeController@update')->name('ppe.update');
    Route::any('ppe/store', 'PpeController@store')->name('ppe.store');
    Route::get('ppe/labelreportpdf/{id}', 'PpeController@LabelReportPdf')->name('ppe.labelreportpdf');
    Route::get('ppe/copyid/{id}', 'PpeController@copyid')->name('ppe.copyid');

    // PPEin
    Route::any('ppein', 'PpeinController@index')->name('ppein');
    Route::any('ppeingetdata', 'PpeinController@getdata');
    Route::any('ppein/edit/{id}', 'PpeinController@edit');

    //PPEDate
    Route::any('ppedate', 'PpedateController@index')->name('ppedate');
    Route::any('ppedategetdata', 'PpedateController@getdata');
    Route::any('ppedate/edit/{id}', 'PpedateController@edit');
    Route::any('ppedategetdata2/{id}', 'PpedateController@getdata2');
    Route::any('ppedatereportpdf', 'PpedateController@reportpdf')->name('ppedate.reportpdf');

    //StockVK
    Route::any('stockvk', 'StockvkController@index')->name('stockvk');
    Route::any('stockvkgetdata', 'StockvkController@getdata');
    Route::any('stockvk/create', 'StockvkController@create');
    Route::any('stockvk/store', 'StockvkController@store')->name('stockvk.store');
    Route::any('stockvk/edit/{id}', 'StockvkController@edit');
    Route::put('stockvk/update/{id}', 'StockvkController@update')->name('stockvk.update');
    Route::any('stockvk/del/{id}', 'StockvkController@dele')->name('stockvk.del');

    //PPEBox
    Route::any('ppebox', 'PpeboxController@index')->name('ppebox');
    Route::any('ppeboxgetdata', 'PpeboxController@getdata');
    Route::any('ppebox/create/{id}', 'PpeboxController@create')->name('ppebox.create');
    Route::any('ppebox/store', 'PpeboxController@store')->name('ppebox.store');

    //PPEPrintBox
    Route::any('ppeprintbox', 'PpePBoxController@index')->name('ppeprintbox');
    Route::any('ppepboxreportpdf', 'PpePBoxController@reportpdf')->name('ppepbox.reportpdf');

    //StockFG New
    Route::any('scannfg', 'ScanFGController@index')->name('scannfg');
    Route::any('scannfggetdata', 'ScanFGController@getdata');
    Route::any('scannfg/edit/{id}', 'ScanFGController@edit');
    Route::any('scannfg/create', 'ScanFGController@create');
    Route::any('scannfg/store', 'ScanFGController@store')->name('scannfg.store');
    Route::any('scannfg/findsku', 'ScanFGController@findsku');
    Route::put('scannfg/update/{id}', 'ScanFGController@update')->name('scannfg.update');
    Route::any('scannfg/reportfg', 'ScanFGController@reportfg')->name('scanfg.reportfg');
    Route::any('scannfg/reportpdffg', 'ScanFGController@reportpdffg')->name('scanfg.reportpdffg');
    Route::any('scannfg/del/{id}', 'ScanFGController@dele')->name('scannfg.del');

   //StockBox New
   Route::any('scanbox', 'ScanboxController@index')->name('scanbox');
   Route::any('scanboxgetdata', 'ScanboxController@getdata');
   Route::any('scanbox/edit/{id}', 'ScanboxController@edit');
   Route::any('scanbox/create', 'ScanboxController@create');
   Route::any('scanbox/store', 'ScanboxController@store')->name('scanbox.store');
   Route::any('scanbox/findsku', 'ScanboxController@findsku');
   Route::put('scanbox/update/{id}', 'ScanboxController@update')->name('scanbox.update');
   Route::any('scanbox/report', 'ScanboxController@report')->name('scanbox.report');
   Route::any('scanbox/reportpdf', 'ScanboxController@reportpdf')->name('scanbox.reportpdf');

   // ScanPack New
   Route::any('scanpack', 'ScanPackController@index')->name('scanpack');
   Route::any('scanpackgetdata', 'ScanPackController@getdata');
   Route::any('scanpack/create', 'ScanPackController@create');
   Route::any('scanpack/store', 'ScanPackController@store')->name('scanpack.store');
   Route::any('scanpack/findsku', 'ScanPackController@findsku');
   Route::any('scanpack/edit/{id}', 'ScanPackController@edit');
   Route::put('scanpack/update/{id}', 'ScanPackController@update')->name('scanpack.update');
   Route::any('scanpack/report', 'ScanPackController@report')->name('scanpack.report');
   Route::any('scanpack/reportpdf', 'ScanPackController@reportpdf')->name('scanpack.reportpdf');
   Route::any('scanpack/del/{id}', 'ScanPackController@dele')->name('scanpack.del');

   // Plan Booking
   Route::any('planbook', 'PlanBookController@index')->name('planbook');
   Route::any('planbookgetdata', 'PlanBookController@getdata');
   Route::any('planbook/findsku', 'PlanBookController@findsku');
   Route::any('planbook/create', 'PlanBookController@create');
   Route::any('planbook/edit/{id}', 'PlanBookController@edit');
   Route::any('planbook/store', 'PlanBookController@store')->name('planbook.store');
   Route::put('planbook/update/{id}', 'PlanBookController@update')->name('planbook.update');
   Route::any('planbook/report', 'PlanBookController@report')->name('planbook.report');
   Route::any('planbook/reportpdf', 'PlanBookController@reportpdf')->name('planbook.reportpdf');
   Route::any('planbook/balance', 'PlanBookController@balance')->name('planbook.balance');
   Route::any('planbookgetdata2', 'PlanBookController@getdata2');
   Route::any('planbookdetial1/{item1}/{si}', 'PlanBookController@detial1');
   Route::any('planbook/showd/{item1}/{si}', 'PlanBookController@showd')->name('planbook.showd');
   Route::any('planbook/del/{id}', 'PlanBookController@dele')->name('planbook.del');
   Route::any('planbook/balance2', 'PlanBookController@balance2')->name('planbook.balance2');
   Route::any('planbookgetdata3', 'PlanBookController@getdata3');
   Route::any('planbook/del2/{id}', 'PlanBookController@dele2')->name('planbook.del2');
   Route::any('planbook/dedit/{id}', 'PlanBookController@dedit')->name('planbook.dedit');
   Route::any('planbook/udetial/{id}', 'PlanBookController@udetial')->name('planbook.udetial');

   // QC In
   Route::any('qcin', 'QcInController@index')->name('qcin');
   Route::any('qcingetdata', 'QcInController@getdata');
   Route::any('qcin/qcin2', 'QcInController@inputqc')->name('qcin2');
   Route::any('qcingetdata2', 'QcInController@getdata2');
   Route::any('qcin/edit/{id}', 'QcInController@edit');
   Route::put('qcin/update/{id}', 'QcInController@update')->name('qcin.update');
   Route::any('qcin/create/{id}', 'QcInController@create')->name('qcin.create');
   Route::any('qcin/store/{id}', 'QcInController@store')->name('qcin.store');
   Route::any('qcin/report', 'QcInController@report')->name('qcin.report');
   Route::any('qcin/reportpdf', 'QcInController@reportpdf')->name('qcin.reportpdf');

    // Cut
    Route::any('cutcloth', 'CutclothController@index')->name('cutcloth');
    Route::any('cutclothgetdata', 'CutclothController@getdata');
    Route::any('cutcloth/inputcut', 'CutclothController@inputcut')->name('cutcloth.inputcut');
    Route::any('cutclothgetdata2', 'CutclothController@getdata2');
    Route::any('cutcloth/findsku', 'CutclothController@findsku');
    Route::any('cutcloth/create/{id}/{item1}/{si}', 'CutclothController@create')->name('cutcloth.create');
    Route::any('cutcloth/store/', 'CutclothController@store')->name('cutcloth.store');
    Route::any('cutcloth/showd/{a}/{b}/{c}', 'CutclothController@showd')->name('cutcloth.showd');
    Route::any('cutcloth/edit/{id}', 'CutclothController@edit');
    Route::put('cutcloth/update/{id}', 'CutclothController@update')->name('cutcloth.update');
    Route::any('cutcloth/dele/{id}', 'CutclothController@dele')->name('cutcloth.dele');
    Route::any('cutcloth/report', 'CutclothController@report')->name('cutcloth.report');
    Route::any('cutcloth/reportpdf', 'CutclothController@reportpdf')->name('cutcloth.reportpdf');

    // Send Sew ส่งงานเย็บ
    Route::any('sendsew', 'SendSewController@index')->name('sendsew');
    Route::any('sendsewgetdata', 'SendSewController@getdata');
    Route::any('sendsew/sendsew2', 'SendSewController@inputqc')->name('sendsew2');
    Route::any('sendsewgetdata2', 'SendSewController@getdata2');
    Route::any('sendsew/create/', 'SendSewController@create')->name('sendsew.create');
    Route::any('sendsew/findsku', 'CutclothController@findsku');
    Route::any('sendsew/store/', 'SendSewController@store')->name('sendsew.store');
    Route::any('sendsew/edit/{id}', 'SendSewController@edit');
    Route::put('sendsew/update/{id}', 'SendSewController@update')->name('sendsew.update');
    Route::any('sendsew/dele/{id}', 'SendSewController@dele')->name('sendsew.dele');
    Route::any('sendsew/report', 'SendSewController@report')->name('sendsew.report');
    Route::any('sendsew/reportpdf', 'SendSewController@reportpdf')->name('sendsew.reportpdf');


    // Qc Eject
    Route::any('qcbad', 'QcBadController@index')->name('qcbad');
    Route::any('qcbadgetdata', 'QcBadController@getdata');
    Route::any('qcbad/create', 'QcBadController@create');
    Route::any('qcbad/findsku', 'QcBadController@findsku');
    Route::any('qcbad/store', 'QcBadController@store')->name('qcbad.store');
    Route::any('qcbad/edit/{id}', 'QcBadController@edit');
    Route::put('qcbad/update/{id}', 'QcBadController@update')->name('qcbad.update');
    Route::any('qcbad/report', 'QcBadController@report')->name('qcbad.report');
    Route::any('qcbad/reportpdf', 'QcBadController@reportpdf')->name('qcbad.reportpdf');
    Route::any('qcbad/del/{id}', 'QcBadController@dele')->name('qcbad.del');

    // Qc Repair
    Route::any('qcre', 'QcReController@index')->name('qcre');
    Route::any('qcregetdata', 'QcReController@getdata');
    Route::any('qcre/create', 'QcReController@create');
    Route::any('qcre/findsku', 'QcReController@findsku');
    Route::any('qcre/store', 'QcReController@store')->name('qcre.store');
    Route::any('qcre/edit/{id}', 'QcReController@edit');
    Route::put('qcre/update/{id}', 'QcReController@update')->name('qcre.update');
    Route::any('qcre/report', 'QcReController@report')->name('qcre.report');
    Route::any('qcre/reportpdf', 'QcReController@reportpdf')->name('qcre.reportpdf');
    Route::any('qcre/del/{id}', 'QcReController@dele')->name('qcre.del');

    // บัญชีใหม่
    Route::any('orderacc', 'OrderAccController@index')->name('orderacc');
    Route::any('orderaccgetdata', 'OrderAccController@getdata');
    Route::any('orderacc/showd/{id}', 'OrderAccController@showd')->name('orderacc.showd');

    // ตรวจสอบการผลิต
    Route::any('ordercheck', 'OrderCheckController@index')->name('ordercheck');
    Route::any('ordercheckgetdata', 'OrderCheckController@getdata');
    Route::any('ordercheck/showd/{id}', 'OrderCheckController@showd')->name('ordercheck.showd');

    // ตรวจสอบการลงกล่อง
    Route::any('boxcheck', 'SendImportFileController@index')->name('boxcheck');
    Route::any('sendImportfile', 'SendImportFileController@index')->name('sendImportfile');
    Route::any('sendImportgetdata', 'SendImportFileController@getdata');
    Route::any('sendImportfile/create', 'SendImportFileController@create')->name('sendimportfile.create');
    //Route::any('boxcheck', 'BoxCheckController@index')->name('boxcheck');
    Route::any('boxcheckgetdata', 'BoxCheckController@getdata');
    Route::any('sendImportfile/edit/{id}', 'SendImportFileController@edit');
    Route::put('sendImportfile/update/{id}', 'SendImportFileController@update')->name('sendImportfile.update');
    Route::any('sendImportfile/del/{id}', 'SendImportFileController@dele')->name('sendImportfile.del');


    // ฟอกใหม่ Bleaching
    Route::any('bleaching', 'BleachingController@index')->name('bleaching');
    Route::any('bleachgetdata', 'BleachingController@getdata');
    Route::any('bleaching/create', 'BleachingController@create');
    Route::any('bleaching/store', 'BleachingController@store')->name('bleaching.store');
    Route::any('bleaching/edit/{id}', 'BleachingController@edit');
    Route::put('bleaching/update/{id}', 'BleachingController@update')->name('bleaching.update');
    Route::any('bleaching/report', 'BleachingController@report')->name('bleaching.report');
    Route::any('bleaching/reportpdf', 'BleachingController@reportpdf')->name('bleaching.reportpdf');
    Route::any('bleaching/del/{id}', 'BleachingController@dele')->name('bleaching.del');

    // แม่สอด รับงานเย็บ 35
    Route::any('sewin', 'SewInController@index')->name('sewin');
    Route::any('sewingetdata', 'SewInController@getdata');
    Route::any('sewin/create', 'SewInController@create');
    Route::any('sewin/findsku', 'SewInController@findsku');
    Route::any('sewin/store', 'SewInController@store')->name('sewin.store');
    Route::any('sewin/edit/{id}', 'SewInController@edit');
    Route::put('sewin/update/{id}', 'SewInController@update')->name('sewin.update');
    Route::any('sewin/del/{id}', 'SewInController@dele')->name('sewin.del');
    Route::any('sewin/report', 'SewInController@report')->name('sewin.report');
    Route::any('sewin/reportpdf', 'SewInController@reportpdf')->name('sewin.reportpdf');


    // แม่สอด ส่งโรงฟอก 36
    Route::any('sewout', 'SewOutController@index')->name('sewout');
    Route::any('sewoutgetdata', 'SewOutController@getdata');
    Route::any('sewout/create', 'SewOutController@create');
    Route::any('sewout/findsku', 'SewOutController@findsku');
    Route::any('sewout/store', 'SewOutController@store')->name('sewout.store');
    Route::any('sewout/edit/{id}', 'SewOutController@edit');
    Route::put('sewout/update/{id}', 'SewOutController@update')->name('sewout.update');
    Route::any('sewout/del/{id}', 'SewOutController@dele')->name('sewout.del');
    Route::any('sewout/report', 'SewOutController@report')->name('sewout.report');
    Route::any('sewout/reportpdf', 'SewOutController@reportpdf')->name('sewout.reportpdf');



    // สิทธิการใช้ เมนู
    Route::any('usermenu', 'RmenuController@index')->name('usermenu');
    Route::any('usermenu/edit/{id}', 'RmenuController@edit')->name('usermenu.edit');
    Route::put('usermenu/update/{id}', 'RmenuController@update')->name('usermenu.update');



});

//Clear route cache:
Route::get('/route-cache', function () {

    $exitCode = Artisan::call('route:cache');
    return 'Routes cache cleared';
});

//Clear config cache:
Route::get('/config-cache', function () {
    $exitCode = Artisan::call('config:cache');
    return 'Config cache cleared';
});

// Clear application cache:
Route::get('/clear-cache', function () {
    $exitCode = Artisan::call('cache:clear');
    return 'Application cache cleared';
});

// Clear view cache:
Route::get('/view-clear', function () {
    $exitCode = Artisan::call('view:clear');
    return 'View cache cleared';
});


