<?php $__env->startSection('title', env('APP_NAME') . ' | เพิ่ม'); ?>

<?php $__env->startSection('styles'); ?>
<style>
.my-custom-scrollbar {
position: relative;
height: 300px;
overflow: auto;
}
.table-wrapper-scroll-y {
display: block;
}

.table tbody tr > td.success {
  background-color: #dff0d8 !important;
}

.table tbody tr > td.error {
  background-color: red !important;
}

.table tbody tr > td.warning {
  background-color: #fcf8e3 !important;
}

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header text-white bg-dark">
                        Scan สินค้าลงกล่อง
                    </div><!--card-header-->
                    <div class="card-body">
                        <div class="row d-flex " >
                            <div class="form-group col-12" >
                                <div class="form-group col-6" >
                                    <label for="XIUser_id">พนักงาน Pack</label>
                                    <input type="hidden" class="form-control" id="XIUser_id" name="XIUser_id" placeholder="" value="<?php echo e(\Auth::user()->id); ?>">
                                    <input type="text" class="form-control" id="XVUser_name" name="XVUser_name" placeholder="ชื่อพนักงาน" value="<?php echo e(\Auth::user()->name); ?>" readonly>
                                </div>
                                <div class="form-group col-6">
                                    <label for="XVBoxCode">บาร์โค้ดกล่อง</label>
                                    <input type="text" style="margin-top:10px;" name="XVBoxCode" id="XVBoxCode" class="form-control" placeholder="แสกนบาร์โค้ด(กล่อง)" value="">
                                </div>
                                <div class="form-group col">
                                    <label for="XVOrderBCode">บาร์โค้ดสินค้า</label>
                                    <input type="text" style="margin-top:10px;" name="XVOrderBCode" id="XVOrderBCode" class="form-control" placeholder="แสกนบาร์โค้ด(สินค้า)" value="">
                                </div>
                            </div>
                        </div>
                        <div class="table-wrapper-scroll-y my-custom-scrollbar">
                        <table class="table table-bordered table-striped mb-0" cellspacing="0"  width="100%" id="myTable">
                            <thead class="thead-dark">
                                <tr>
                                <th scope="col">Item No</th>
                                <th scope="col">UPC Code</th>
                                <th scope="col">SKU Code</th>
                                <th scope="col">Description</th>
                                <th scope="col">Size</th>
                                <th scope="col" class="text-center">QTY Order</th>
                                <th scope="col" class="text-center">QTY Packing</th>
                                <th scope="col">View</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                        </div>

                    </div>
                    <div class="card-footer">
                    <div class="row">
                        <div class="col">
                            <a href="<?php echo e(route('admin.scanproductinbox.index')); ?>" class="btn btn-dark col-lg-2 active" role="button" aria-pressed="true">กลับ</a>
                        </div>

                    </div>
                    </div>
                </div><!--card-->
            </div><!--col-->
        </div><!--row-->

<?php $__env->stopSection(); ?>

    <?php $__env->startSection('scripts'); ?>
    <script>
          $(function () {
            $(document).ajaxSend(function() {
                $("#overlay").fadeIn(300);　
            });

            if($('#XVBoxCode').val() !=""){
                $('#XVOrderBCode').focus();
            }else{
                $('#XVBoxCode').focus();
            }

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            const Toast = Swal.mixin({
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 1000,
            timerProgressBar: true,
            onOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
            })



            $('.dataTables_length').addClass('bs-select');
            var boxno = '<?php echo e($boxno); ?>'
            if (boxno != ''){
                $('#XVBoxCode').val(boxno)
                getData();
            }



            var count_scan = 0;
            $('#XVOrderBCode').keyup(function(e){
                if(e.keyCode == 13)
                {
                    // console.log($('#XVOrderBCode').val());

                    $this = $(this);
                    if ($('#XVBoxCode').val().length == 0){
                        Swal.fire({
                        title: 'Oops....',
                        text: "กรุณณาระบุบาร์โค้ดกล่อง!",
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.value) {
                                return false;
                            }
                        })
                    }else{

                     $.ajax({
                        type:'POST',
                        url:'<?php echo e(url('')); ?>/admin/scanproductinboxUpdate',
                        data:{barcode: $this.val(),boxCode:$('#XVBoxCode').val(),location:9},
                        dataType: 'JSON',
                        success:function(data){
                            console.log(data)
                            if(data.success =="0"){
                                Swal.fire({
                                title: 'Oops....',
                                text: "ไม่พบข้อมูลในระบบกรุณาตรวจสอบ !",
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.value) {
                                    $('#order_no').html("")
                                    $('#size').html("")

                                }
                                })
                            }else if(data.success == "2"){

                                Swal.fire({
                                title: 'Oops....',
                                text: data.message,
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                    $('#order_no').html("")
                                    $('#size').html("")
                                    $this.val('')
                                        return false;
                                })
                            }
                            else{
                                Toast.fire({
                                icon: 'success',
                                title: 'Scan สำเร็จ'

                                })
                    $('#myTable tbody tr').empty();
                                // console.log(result.datas[0].XVOrderBCode)
                                // for (var data in result.datas) {
                                for (i = 0; i < data.Boxs.length; i++) {
                                    var class_status ='error';
                                     if(data.Boxs[i].XISupQty === data.Boxs[i].QtyPack ){
                                         class_status = 'success';
                                     }
                                    $('#myTable tbody').append($("<tr>")
                                        .append($('<td>', { text: data.Boxs[i].ItemNo  }))
                                        .append($('<td>', { text: data.Boxs[i].XVUPCCode }))
                                        .append($('<td>', { text: data.Boxs[i].XVSKUCode }))
                                        .append($('<td>', { text: data.Boxs[i].XVDescription }))
                                        .append($('<td>', { text: data.Boxs[i].XVSize }))

                                        .append($("<td >", { text: data.Boxs[i].XISupQty }).addClass(class_status))
                                        .append($('<td >', { html: data.Boxs[i].QtyPack }).addClass(class_status))


                                        .append($('<td>', { html: '<a href="<?php echo e(url("admin/scanproductinboxGetitem/")); ?>/'+$('#XVBoxCode').val()+'/'+data.Boxs[i].XVSize+'/'+data.Boxs[i].ItemNo+'/'+data.Boxs[i].XVDescription+'" class="btn btn-secondary btn_view" data-toggle="tooltip" data-placement="top" title="แสดงบาร์โค้ด"><i class="fas fa-search"></i></a>'}))

                                    )

                                }
                                $this.val('')
                            }
                            setTimeout(function(){$("#overlay").fadeOut(300);},500);
                        }
                        }).done(function() {
                            setTimeout(function(){
                                $("#overlay").fadeOut(300);
                            },500);
                        });
                    }
                }
            });

            $('#XVBoxCode').keyup(function(e){
                console.log($('#XVBoxCode').val())
                if(e.keyCode == 13)
                {
                    getData();
                }
            })

            function getData(){
                var row=1;

                     $.ajax({
                        type:'POST',
                        url:'<?php echo e(url('')); ?>/admin/scanproductinboxGetByBox',
                        data:{boxCode:$('#XVBoxCode').val(),location:9},
                        dataType: 'JSON',
                        success:function(result){

                            if(result.success =="0"){
                                Swal.fire({
                                title: 'Oops....',
                                text: "ไม่พบข้อมูลในระบบกรุณาตรวจสอบ !",
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.value) {
                                    $('#order_no').html("")
                                    $('#size').html("")
                                }
                                })
                            }else{
                                Toast.fire({
                                icon: 'success',
                                title: 'Scan สำเร็จ'
                                })

                                $('#myTable tbody tr').empty();
                                // console.log(result.datas[0].XVOrderBCode)
                                // for (var data in result.datas) {
                                for (i = 0; i < result.Boxs.length; i++) {
                                     var class_status ='error text-white text-center';
                                     var class_status2 ='bg-warning text-white text-center';
                                     if(result.Boxs[i].XISupQty === result.Boxs[i].QtyPack ){
                                         class_status = 'success';
                                         class_status2 ='success';
                                     }


                                    $('#myTable tbody').append($("<tr id=r"+row+">")
                                        .append($('<td>', { text: result.Boxs[i].ItemNo  }))
                                        .append($('<td>', { text: result.Boxs[i].XVUPCCode }))
                                        .append($('<td>', { text: result.Boxs[i].XVSKUCode }))
                                        .append($('<td>', { text: result.Boxs[i].XVDescription }))
                                        .append($('<td>', { text: result.Boxs[i].XVSize }))

                                        .append($("<td >", { text: result.Boxs[i].XISupQty }).addClass(class_status))
                                        .append($('<td >', { html: result.Boxs[i].QtyPack }).addClass(class_status2))


                                        .append($('<td>', { html: '<a href="<?php echo e(url("admin/scanproductinboxGetitem/")); ?>/'+$('#XVBoxCode').val()+'/'+result.Boxs[i].XVSize+'/'+result.Boxs[i].ItemNo+'/'+result.Boxs[i].XVDescription+'" class="btn btn-secondary btn_view" data-toggle="tooltip" data-placement="top" title="แสดงบาร์โค้ด"><i class="fas fa-search"></i></a>'}))


                                    )
                                    row++;
                                }
                            }
                             $('#XVOrderBCode').focus();
                            setTimeout(function(){$("#overlay").fadeOut(300);},500);
                        }
                        }).done(function() {
                            setTimeout(function(){
                                $("#overlay").fadeOut(300);
                            },500);
                        });
            }

          })

          function  del(code,row) {

                Swal.fire({
                title: 'ยืนยันการยกเลิก ?',
                text: "คุณต้องการยกเลิกรายการเลขที่ "+ code +" ใช่หรือไม่ !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'ยืนยัน !',
                cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                if (result.value) {
                    $.ajax({
                        type:'POST',
                        url:'<?php echo e(url('')); ?>/admin/scanproductinboxDel',
                        data:{barcode:code,location:9},
                        dataType: 'JSON',
                        success:function(result){
                            if (result.success ==1)
                            $('#r'+row).remove();
                        }
                        }).done(function() {
                            setTimeout(function(){
                                $("#overlay").fadeOut(300);
                            },500);
                        });
                }
                })
          }

    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vk/resources/views/admin/scanproductinbox/create.blade.php ENDPATH**/ ?>