
<?php $__env->startSection('content'); ?>

<div class="card">
    <div class="card-header">
        <?php echo e(trans('global.create')); ?> <?php echo e(trans('global.user.title_singular')); ?>

    </div>

    <div class="card-body">
        <form action="<?php echo e(route("admin.users.store")); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="form-group <?php echo e($errors->has('name') ? 'has-error' : ''); ?>">
                <label for="name"><?php echo e(trans('global.user.fields.name')); ?>*</label>
                <input type="text" id="name" name="name" class="form-control" value="<?php echo e(old('name', isset($user) ? $user->name : '')); ?>" required>
                <?php if($errors->has('name')): ?>
                    <em class="invalid-feedback">
                        <?php echo e($errors->first('name')); ?>

                    </em>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('global.user.fields.name_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('XVEmpCode') ? 'has-error' : ''); ?>">
                <label for="XVEmpCode">รหัสพนักงาน *</label>
                <input type="text" id="XVEmpCode" name="XVEmpCode" class="form-control" value="<?php echo e(old('XVEmpCode', isset($user) ? $user->XVEmpCode : '')); ?>" required>
                <?php if($errors->has('XVEmpCode')): ?>
                    <em class="invalid-feedback">
                        <?php echo e($errors->first('XVEmpCode')); ?>

                    </em>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('global.user.fields.XVEmpCode_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('XVCardID') ? 'has-error' : ''); ?>">
                <label for="XVCardID">เลขที่บัตรประชาชน *</label>
                <input type="text" id="XVCardID" name="XVCardID" class="form-control" value="<?php echo e(old('XVCardID', isset($user) ? $user->XVCardID : '')); ?>" required>
                <?php if($errors->has('XVCardID')): ?>
                    <em class="invalid-feedback">
                        <?php echo e($errors->first('XVCardID')); ?>

                    </em>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('global.user.fields.name_helper')); ?>

                </p>
            </div>

            <div class="form-group <?php echo e($errors->has('email') ? 'has-error' : ''); ?>">
                <label for="email"><?php echo e(trans('global.user.fields.email')); ?>*</label>
                <input type="email" id="email" name="email" class="form-control" value="<?php echo e(old('email', isset($user) ? $user->email : '')); ?>" required>
                <?php if($errors->has('email')): ?>
                    <em class="invalid-feedback">
                        <?php echo e($errors->first('email')); ?>

                    </em>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('global.user.fields.email_helper')); ?>

                </p>
            </div>
            <div class="form-group <?php echo e($errors->has('password') ? 'has-error' : ''); ?>">
                <label for="password"><?php echo e(trans('global.user.fields.password')); ?></label>
                <input type="password" id="password" name="password" class="form-control" required>
                <?php if($errors->has('password')): ?>
                    <em class="invalid-feedback">
                        <?php echo e($errors->first('password')); ?>

                    </em>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('global.user.fields.password_helper')); ?>

                </p>
            </div>

            <div class="form-group <?php echo e($errors->has('XIBranchCode') ? 'has-error' : ''); ?>">
                <label for="XIBranchCode">สังกัดแผนก *</label>

                <select name="XIBranchCode" id="XIBranchCode" class="form-control" required>
                    <option value="">-- Select --</option>
                    <?php $__currentLoopData = $branchs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($branch->XIBranchCode); ?>">
                            <?php echo e($branch->XVBranchName); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="form-group <?php echo e($errors->has('roles') ? 'has-error' : ''); ?>">
                <label for="roles"><?php echo e(trans('global.user.fields.roles')); ?>*
                    <span class="btn btn-info btn-xs select-all">Select all</span>
                    <span class="btn btn-info btn-xs deselect-all">Deselect all</span></label>
                <select name="roles[]" id="roles" class="form-control select2" multiple="multiple" required>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $roles): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($id); ?>" <?php echo e((in_array($id, old('roles', [])) || isset($user) && $user->roles->contains($id)) ? 'selected' : ''); ?>>
                            <?php echo e($roles); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <?php if($errors->has('roles')): ?>
                    <em class="invalid-feedback">
                        <?php echo e($errors->first('roles')); ?>

                    </em>
                <?php endif; ?>
                <p class="helper-block">
                    <?php echo e(trans('global.user.fields.roles_helper')); ?>

                </p>
            </div>
            <div>
                <input class="btn btn-danger" type="submit" value="<?php echo e(trans('global.save')); ?>">
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vk/resources/views/admin/users/create.blade.php ENDPATH**/ ?>