

<?php $__env->startSection('title', env('APP_NAME') . ' | หน้าจอลูกค้า'); ?>

<?php $__env->startSection('content'); ?>

<div class="card">

  <div class="card-header">
      <?php echo e(trans('global.TMcustomer.title_singular')); ?>

  </div>

    <div class="card-body">
        <div class="row">

            <div class="col-sm-12 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="<?php echo e(route('admin.customer.create')); ?>" class="btn btn-success ml-1 active" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i> เพิ่มข้อมูล</a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table  class="table table-bordered table-striped table-hover datatable">
                        <thead>
                            <tr>
                                
                                <th width="8%"><?php echo e(trans('global.TMcustomer.fields.XIGuestCode')); ?></th>
                                <th><?php echo e(trans('global.TMcustomer.fields.XVGuestName')); ?></th>
                                <th><?php echo e(trans('global.TMcustomer.fields.XVNameContact')); ?></th>
                                <th><?php echo e(trans('global.TMcustomer.fields.XVGuestTel')); ?></th>
                                <th><?php echo e(trans('global.TMcustomer.fields.XVGuestAddress')); ?></th>
                                <th width="15%"><?php echo e(trans('global.manage')); ?></th>
                            </tr>
                        </thead>
                        <tbody>

                          <?php $__currentLoopData = $customer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $custom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <tr data-entry-id="<?php echo e($custom->XIGuestCode); ?>">
                                  
                                  <td>
                                      <?php echo e($custom->XIGuestCode ?? ''); ?>

                                  </td>
                                  <td>
                                      <?php echo e($custom->XVGuestName ?? ''); ?>

                                  </td>
                                  <td>
                                      <?php echo e($custom->XVNameContact ?? ''); ?>

                                  </td>
                                  <td>
                                      <?php echo e($custom->XVGuestTel ?? ''); ?>

                                  </td>
                                  <td>
                                      <?php echo e($custom->XVGuestAddress ?? ''); ?>

                                  </td>
                                  <td>

                                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer_edit')): ?>
                                        <a href="<?php echo e(route('admin.customer.edit', $custom->XIGuestCode)); ?>" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข">
                                              <i class="fas fa-edit"></i>
                                          </a>
                                      <?php endif; ?>

                                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer_delete')): ?>
                                            <form action="<?php echo e(route('admin.customer.destroy', $custom->XIGuestCode)); ?>" method="POST" onsubmit="return confirm('<?php echo e(trans('global.areYouSure')); ?>');" style="display: inline-block;">
                                                <input type="hidden" name="_method" value="DELETE">
                                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                <button  type="submit" class="btn btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('global.delete')); ?></button>
                                            </form>
                                      <?php endif; ?>

                                  </td>

                              </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->

    <?php $__env->startSection('scripts'); ?>
    <script>
          $(function () {

              let deleteButtonTrans = '<?php echo e(trans('global.datatables.delete')); ?>'
              let deleteButton = {
                text: deleteButtonTrans,
                url: "<?php echo e(route('admin.customer.massDestroy')); ?>",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                  var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                      return $(entry).data('entry-id')
                  });

                  if (ids.length === 0) {
                    alert('<?php echo e(trans('global.datatables.zero_selected')); ?>')

                    return
                  }

                  if (confirm('<?php echo e(trans('global.areYouSure')); ?>')) {
                    $.ajax({
                      headers: {'x-csrf-token': _token},
                      method: 'POST',
                      url: config.url,
                      data: { ids: ids, _method: 'DELETE' }})
                      .done(function () { location.reload() })
                  }
                }
              }

              let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)

            //   <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer_delete')): ?>
            //     dtButtons.push(deleteButton)
            //   <?php endif; ?>

              $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
          })
    </script>
    <?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vk/resources/views/admin/customer/index.blade.php ENDPATH**/ ?>