<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FinishGoodAdjustController extends Controller
{
    public function index()
    {
        $HD = DB::table('tdoctfahd')
            ->leftjoin('vk2_users', 'tdoctfahd.XVFahExaminer', 'vk2_users.id')
            ->orderBy('XVFahDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('FA.index', $data);
    }
    public function Approveindex()
    {
        $HD = DB::table('tdoctfahd')
            ->leftjoin('vk2_users', 'tdoctfahd.XVFahExaminer', 'vk2_users.id')
            ->orderBy('XVFahDocNo', 'DESC')
            ->where('XVFahDocStatus','2')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view('FA.index', $data);
    }



    public function FormInsert()
    {

        return view('FA.frm_add', [
        ]);
    }

    public function FormEdit($DocNo)
    {
        $hd = DB::table('tdoctfahd')
            ->where('XVFahDocNo', '=', $DocNo)
            ->first();

        $dt = DB::table('tdoctfadt')
            ->leftJoin('tmstmproduct', 'tdoctfadt.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->where('XVFahDocNo', '=', $DocNo)
            ->get();
        foreach ($dt as $item) {
            $qty = DB::table('tstktmatstockcardproduct')
                ->where('xvpdtcode','=',$item->xvpdtcode)
                ->where('xvpszname','=',$item->XVPszName)
                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
                ->first();
            $item->SumQty = $qty->SumQty ?? 0;
        }
//        $xvpdtcode = $hd->xvpdtcode ?? null;;

        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,
            'DocStatus' => $hd->XVFahDocStatus,
        ];

        return view('FA.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDFahDocDate);
        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('tdoctfahd', 'XVFahDocNo', 'FA', 2);
            DB::table('tdoctfahd')->insert([
                'XVFahDocNo' => $code,
                'XDFahDocDate' => $date->format('Y-m-d'),
                'XVFahDocStatus' => 1,
                'XVFahDocRmk' => $request->XVFahDocRmk,
                'XVFahExaminer' => $request->SelectUsers,
            ]);
            foreach ($request->XVPszName as $key => $item) {
//                $itemFactor = DB::table('tmstmmat_unit')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
//                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
//                    ->first();
                DB::table('tdoctfadt')->insert([
                    'XVFahDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key],
                    'XVPszName' => $request->XVPszName[$key],
                    'XIFadQty' => $request->XIFadQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('fa.edit', $code)->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
//        dd($request->all());
        $date = Carbon::createFromFormat('d-m-Y', $request->XDFahDocDate);
        try {
            DB::beginTransaction();
            $code = $request->XVFahDocNo;
            DB::table('tdoctfahd')
                ->where('XVFahDocNo', '=', $code)
                ->update([
                    'XDFahDocDate' => $date->format('Y-m-d'),
                    'XVFahDocStatus' => 1,
                    'XVFahDocRmk' => $request->XVFahDocRmk,
                    'XVFahExaminer' => $request->SelectUsers,
                ]);
            DB::table('tdoctfadt')
                ->where('XVFahDocNo', '=', $code)->delete();
            foreach ($request->XVPszName as $key => $item) {
//                $itemFactor = DB::table('tmstmmat_unit')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
//                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
//                    ->first();
                DB::table('tdoctfadt')->insert([
                    'XVFahDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key],
                    'XVPszName' => $request->XVPszName[$key],
                    'XIFadQty' => $request->XIFadQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('fa.edit', $code)->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVFahDocNo;
            $requestChange = $request->eventRequest;
            $HD = DB::table('tdoctfahd')
                ->where('XVFahDocNo', '=', $docNo)
                ->first();

            $DocStatus = $HD->XVFahDocStatus;
            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve

                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $isNotBalancePreviosMonth = checkBalancePreviousMonth("tstktmatstockcardproduct");
                        if($isNotBalancePreviosMonth){
                            return redirect()->back()->with('msg', 'IsNotBalanced');
                        }
                        $this->UpdateStatus($docNo, $requestChange);
                        $dt = DB::table('tdoctfadt')
                            ->where('XVFahDocNo', '=', $docNo)
                            ->get();
                        foreach ($dt as $item) {
                            $qty = DB::table('tstktmatstockcardproduct')
                                ->where('xvpdtcode','=',$item->xvpdtcode)
                                ->where('xvpszname','=',$item->XVPszName)
                                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'),'tstktmatstockcardproduct.*')
                                ->first();
                            if($qty->xfstkcost == null){
//                                $defaultMasterItem = DB::table('tmstmproduct')
//                                    ->where('xvpdtcode','=',$item->xvpdtcode)
//                                    ->select('XFPdtPrice')
//                                    ->first();
                                $price = 0;
                            }else{
                                $price = $qty->xfstkcost;
                            }
                            $Summary = intval($qty->SumQty) ?? 0;

                            if ($item->XIFadQty > $Summary) {
                                $qtyleft = $item->XIFadQty - $Summary;
                                $is_LessThan = false; //default case 5
                            } else {
                                $qtyleft = ($Summary - $item->XIFadQty);
                                $is_LessThan = true;  // case 6
                            }
                            $item->tempQty = $qtyleft;
                            if ($is_LessThan) {
                                //Case 6 === Case 2
                                $itemStockMat = DB::table('tstktmatstockcardproduct')
                                    ->where('xvpdtcode','=',$item->xvpdtcode)
                                    ->where('xvpszname','=',$item->XVPszName)
                                    ->whereIn('xvstktype', [0,1, 5])
                                    ->where('xistkqtyleft', '>', 0)
                                    ->get();

                                foreach ($itemStockMat as $keySTK => $itemSTK) {
//                                    dd($itemStockMat,$itemSTK,$item->tempQty);

                                    if ($itemSTK->xistkqtyleft >= $item->tempQty) {
                                        DB::table('tstktmatstockcardproduct')
                                            ->where('xvpdtcode','=',$itemSTK->xvpdtcode)
                                            ->where('xvpszname','=',$itemSTK->xvpszname)
                                            ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                            ->where('xvstktype', '=', $itemSTK->xvstktype)
                                            ->update([
                                                'xistkqtyuse' => $itemSTK->xistkqtyuse + $item->tempQty,
                                                'xistkqtyleft' => $itemSTK->xistkqtyleft - $item->tempQty,
                                            ]);
//                                        $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $item->tempQty);
                                        $item->tempQty = 0;
                                    } else {
//                                    dd($itemSTK, $item, 'es');

                                        DB::table('tstktmatstockcardproduct')
                                            ->where('xvpdtcode','=',$itemSTK->xvpdtcode)
                                            ->where('xvpszname','=',$itemSTK->xvpszname)
                                            ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                            ->where('xvstktype', '=', $itemSTK->xvstktype)
                                            ->update([
                                                'xistkqtyuse' => $itemSTK->xistkqty,
                                                'xistkqtyleft' => 0,
                                            ]);
//                                        $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $itemSTK->xistkqtyleft);
                                        $item->tempQty = $item->tempQty - $itemSTK->xistkqtyleft;
                                    }
                                    if ($item->tempQty <= 0) {
                                        break;
                                    }
                                }
//                                dd($item,$qtyleft);
                                DB::table('tstktmatstockcardproduct')
                                    ->insert([
                                        'xvpdtcode'=>$item->xvpdtcode,
                                        'xvpszname'=>$item->XVPszName,
                                        'xvstkdocno'=>$docNo,
                                        'xvstktype'=>6,
                                        'xistkqty'=>$qtyleft,
                                        'xistkqtyuse'=>0,
                                        'xistkqtyleft' => $item->tempQty < 0 ? -$item->tempQty : 0,
                                        'xfstkcost'=>$price ,
                                        'xdstkdate'=>$HD->XDFahDocDate,
                                    ]);
                            }
                            else {
                                //Case 5 === Case 1
                                $itemStockMat = DB::table('tstktmatstockcardproduct')
                                    ->where('xvpdtcode','=',$item->xvpdtcode)
                                    ->where('xvpszname','=',$item->XVPszName)
                                    ->whereIn('xvstktype', [2, 6])
                                    ->where('xistkqtyleft', '!=', 0)
                                    ->get();
                                foreach ($itemStockMat as $keySTK => $itemSTK) {
                                    if ($itemSTK->xistkqtyleft + $item->tempQty >= 0) {
                                        $qtyLeftSTK = 0;
                                        $item->tempQty = $itemSTK->xistkqtyleft + $item->tempQty;
                                    } else {
                                        $qtyLeftSTK = $itemSTK->xistkqtyleft + $item->tempQty;
                                        $item->tempQty = 0;
                                    }
                                    DB::table('tstktmatstockcardproduct')
                                        ->where('xvpdtcode','=',$itemSTK->xvpdtcode)
                                        ->where('xvpszname','=',$itemSTK->xvpszname)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyleft' => $qtyLeftSTK,
                                        ]);
                                    if ($item->tempQty <= 0) {
                                        break;
                                    }
                                }
                                DB::table('tstktmatstockcardproduct')
                                    ->insert([
                                        'xvpdtcode'=>$item->xvpdtcode,
                                        'xvpszname'=>$item->XVPszName,
                                        'xvstkdocno'=>$docNo,
                                        'xvstktype'=>5,
                                        'xistkqty' => $qtyleft,
                                        'xistkqtyuse' => $qtyleft - $item->tempQty,
                                        'xistkqtyleft' => $item->tempQty,
                                        'xfstkcost'=>$price ,
                                        'xdstkdate'=>$HD->XDFahDocDate,
                                    ]);

                            }
                            DB::table('tdoctfadt')
                                ->where('XVFahDocNo','=',$item->XVFahDocNo)
                                ->where('xvpdtcode','=',$item->xvpdtcode)
                                ->where('XVPszName','=',$item->XVPszName)
                                ->update([
                                    'XIFadQtyStkBefore'=>$qty->SumQty,
                                    'XIFadQtyAdjust'=>$qtyleft,
                                ]);
                        }

                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('tdoctfahd')
            ->where('XVFahDocNo', '=', $docNo)
            ->update([
                'XVFahDocStatus' => $docStatus
            ]);
    }

    public function getDataForPDF($docNo)
    {
        $hd = DB::table('tdoctgihd')
            ->where('XVGihDocNo', '=', $docNo)
            ->leftjoin('vk2_users', 'tdoctgihd.XIGihUsrID', 'vk2_users.id')
            ->leftJoin('TDocTOrHD', 'tdoctgihd.XVGihDocNoOR', 'TDocTOrHD.XVOrhDocNo')
            ->leftJoin('tmstmcustomer', 'TDocTOrHD.XVCstCode', 'tmstmcustomer.XVCstCode')
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->leftJoin('tmforuse', 'tmstmproduct.XIForCode', 'tmforuse.XIForCode')
            ->leftJoin('tmgenerate', 'tmstmproduct.XIGenerateCode', 'tmgenerate.XIGenerateCode')
            ->leftJoin('tmseason', 'tmstmproduct.XISeasonCode', 'tmseason.XISeasonCode')
            ->leftJoin('tmshape', 'tmstmproduct.XIShapeCode', 'tmshape.XIShapeCode')
            ->leftJoin('TMstMMaterial', 'tmstmproduct.xvmatcode', 'TMstMMaterial.xvmatcode')
            ->first();
        $dt = DB::table('tdoctgidt')
            ->where('XVGihDocNo', '=', $docNo)
            ->leftJoin('tmstmmaterial', 'tdoctgidt.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->leftJoin('tmstmunit', 'tdoctgidt.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get()->toArray();
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,

        ];
        return response()->json($dataSend);
    }
}
