<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterItemSizeController extends Controller
{
    public function index($xvpdtcode)
    {
        $hd = DB::table('tmstmproduct')->where('xvpdtcode', '=', $xvpdtcode)->first();
        $size = DB::table('tmstmproductsize')
            ->where('tmstmproductsize.xvpdtcode', '=', $xvpdtcode)
            ->get();
        foreach ($size as $key => $item){
            $isFound = DB::table('TMstMBomSize')
                ->where('xvpdtcode','=',$item->xvpdtcode)
                ->where('XVPszName','=',$item->XVPszName)
                ->count();
            if($isFound > 0 ){
                $item->HasBom = true;
            }else{
                $item->HasBom = false;
            }
        }
        $data = [
            'hd' => $hd,
            'size'=>$size
        ];
        return view('MasterItemSize.frm_edit', $data);
    }

    public function Update(Request $request)
    {
        try {
            $code = $request->xvpdtcode;
            DB::beginTransaction();
            switch ($request->eventMethod){
                case 'save':
                    DB::table('tmstmproductsize')->insert([
                        'xvpdtcode' => $code,
                        'XVPszName' => $request->XVPszName,
                    ]);
                    break;
                case 'delete':
                    DB::table('tmstmproductsize')
                        ->where('xvpdtcode','=',$code)
                        ->where('XVPszName','=',$request->eventValue)
                        ->delete();
                    DB::table('TMstMBomSize')
                        ->where('xvpdtcode','=',$code)
                        ->where('XVPszName','=',$request->eventValue)
                        ->delete();
                    break;
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            if($e->getCode()==="23000"){
                return redirect()->back()->with('msg', 'Duplicate');
            }
            dd($e);
            abort(500, 'Internal error');
        }
    }
}
