<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report201Controller extends Controller
{

    public function index()
    {
        return view('Report/index201');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $SplStart = $request->input('SplStart');
        $SplEnd = $request->input('SplEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data
        $supplier = DB::table('tmstmsupplier');
        $supplier = condition_LCR($supplier, 'XVSplCode', $isAllSpl, $SplStart, $SplEnd);
        foreach ($supplier as $item) {
            $OrderHD =DB::table('TDocTPoHD')
                ->where('XVPohDocStatus', '=', '3')
                ->where('XVSplCode', '=', $item->XVSplCode);
            $OrderHD = condition_LCR($OrderHD, 'XDPohDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $OrderDT = DB::table('TDocTPoDT')
                        ->where('XVPohDocNo', '=', $itemSecond->XVPohDocNo)
                        ->leftjoin('TMstMMaterial', 'TDocTPoDT.xvmatcode', 'TMstMMaterial.xvmatcode');
                    $summary =  DB::table('TDocTPoDT')
                        ->where('XVPohDocNo', '=', $itemSecond->XVPohDocNo)
                        ->select(DB::raw('SUM(XFPodCostTotal) as SumQty'))
                        ->first();
                    $itemSecond->CostTotal = $summary->SumQty ?? 0;
                    $itemSecond->OrderDT = $OrderDT->get();

                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($supplier);
    }

    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $SplStart = $request->input('SplStart');
        $SplEnd = $request->input('SplEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data
        $supplier = DB::table('TDocTPoDT')
                   ->join('TDocTPoHD','TDocTPoDT.XVPohDocNo','TDocTPoHD.XVPohDocNo')
                   ->where('TDocTPoHD.XVPohDocStatus', '=', '3')
                    ->join('TMstMMaterial', 'TDocTPoDT.xvmatcode', 'TMstMMaterial.xvmatcode')
                    ->join('tmstmsupplier', 'tmstmsupplier.XVSplCode', 'TDocTPoHD.XVSplCode');
        $supplier =  condition_LCRVOutide($supplier, 'TDocTPoHD.XDPohDocDate', $isAllTime, $DateStart, $DateEnd);
        $supplier =  condition_LCR($supplier, 'TDocTPoHD.XVSplCode', $isAllSpl, $SplStart, $SplEnd);
                  
        return response()->json($supplier);
    }

}
