<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report202Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index202');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tmstmmaterial');
        $material = condition_LCR($material, 'xvmatcode', $isAllMat, $MatStart, $MatEnd);
        foreach ($material as $item) {
            $OrderHD = DB::table('TDocTPoDT')
                ->leftjoin('TDocTPoHD', 'TDocTPoDT.XVPohDocNo', 'TDocTPoHD.XVPohDocNo')
                ->where('XVPohDocStatus', '=', '3')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->select('TDocTPoDT.XVPohDocNo','XFPodCostTotal','XDPohDocDate');
            $OrderHD = condition_LCR($OrderHD, 'XDPohDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($material);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('TDocTPoDT')
        ->join('TDocTPoHD','TDocTPoDT.XVPohDocNo','TDocTPoHD.XVPohDocNo')
        ->where('TDocTPoHD.XVPohDocStatus', '=', '3')
         ->join('TMstMMaterial', 'TDocTPoDT.xvmatcode', 'TMstMMaterial.xvmatcode');
         $material = condition_LCRVOutide($material, 'TDocTPoDT.xvmatcode', $isAllMat, $MatStart, $MatEnd);
         $material = condition_LCR($material, 'XDPohDocDate', $isAllTime, $DateStart, $DateEnd);
       
        return response()->json($material);
    }
}
