<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report301Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index301');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $SplStart = $request->input('SplStart');
        $SplEnd = $request->input('SplEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data
        $supplier = DB::table('tmstmsupplier');
        $supplier = condition_LCR($supplier, 'XVSplCode', $isAllSpl, $SplStart, $SplEnd);
        foreach ($supplier as $item) {
            $OrderHD =DB::table('tdoctgrhd')
                ->where('XVGrhDocStatus', '=', '3')
                ->where('XVSplCode', '=', $item->XVSplCode);
            $OrderHD = condition_LCR($OrderHD, 'XDGrhDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $OrderDT = DB::table('tdoctgrdt')
                        ->where('XVGrhDocNo', '=', $itemSecond->XVGrhDocNo);
                    $itemSecond->OrderDT = $OrderDT
                        ->get();
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($supplier);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $SplStart = $request->input('SplStart');
        $SplEnd = $request->input('SplEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data
        $supplier = DB::table('tdoctgrdt');
        $supplier->Join('tdoctgrhd','tdoctgrdt.XVGrhDocNo','tdoctgrhd.XVGrhDocNo')
                 ->where('XVGrhDocStatus', '=', '3')
                ->Join('tmstmsupplier','tdoctgrhd.XVSplCode','tmstmsupplier.XVSplCode');
                $supplier = condition_LCRVOutide( $supplier, 'tdoctgrhd.XVSplCode',  $isAllSpl, $SplStart, $SplStart);
                  $supplier = condition_LCR( $supplier, 'XDGrhDocDate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($supplier);
    }
}
