<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report302Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index302');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tmstmmaterial');
        $material = condition_LCR($material, 'xvmatcode', $isAllMat, $MatStart, $MatEnd);
        foreach ($material as $item) {
            $OrderHD =DB::table('tdoctgrdt')
                ->leftJoin('tdoctgrhd','tdoctgrdt.XVGrhDocNo','tdoctgrhd.XVGrhDocNo')
                ->where('XVGrhDocStatus', '=', '3')
                ->where('xvmatcode', '=', $item->xvmatcode);
            $OrderHD = condition_LCR($OrderHD, 'XDGrhDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($material);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $supplier = DB::table('tdoctgrdt');
        $supplier->Join('tdoctgrhd','tdoctgrdt.XVGrhDocNo','tdoctgrhd.XVGrhDocNo')
                 ->where('XVGrhDocStatus', '=', '3')
                ->orderBy('xvmatcode');
                $supplier = condition_LCRVOutide($supplier, 'tdoctgrdt.xvmatcode', $isAllMat, $MatStart, $MatEnd);
                $supplier = condition_LCR( $supplier, 'XDGrhDocDate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($supplier);
    }
}
