<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report303Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index303');
    }
    public function data(Request $request)
    {
        //        Section Data
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tmstmmaterial');
        $material = condition_LCR($material, 'xvmatcode', $isAllMat, $MatStart, $MatEnd);
        foreach ($material as $item) {
            $itemFactor = DB::table('tmstmmat_unit')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->orderBy('ximunfactor','asc')
                ->leftJoin('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                ->first();
            $summary = DB::table('tstktmatstockcard')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
                ->first();
            $item->qty = $summary->SumQty ?? 0;
            $item->minimumFactor = $itemFactor->ximunfactor;
            $item->factorName = $itemFactor->xvuntname;

        }
        return response()->json($material);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $MatStart = $request->input('MatStart');
        $MatEnd = $request->input('MatEnd');
        $isAllMat = $request->input("isAllMat") === 'true' ? true : false;
        //        Section Data
        $material = DB::table('tmstmmaterial');
        $material = condition_LCR($material, 'xvmatcode', $isAllMat, $MatStart, $MatEnd);
        foreach ($material as $item) {
            $itemFactor = DB::table('tmstmmat_unit')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->orderBy('ximunfactor','asc')
                ->leftJoin('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                ->first();
            $summary = DB::table('tstktmatstockcard')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
                ->first();
            $item->qty = $summary->SumQty ?? 0;
            $item->minimumFactor = $itemFactor->ximunfactor;
            $item->factorName = $itemFactor->xvuntname;

        }
        return response()->json($material);
    }
}
