<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report305Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index305');
    }

    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $OrderStart = $request->input('OrderStart');
        $OrderEnd = $request->input('OrderEnd');
        $isAllOrder = $request->input("isAllOrder") === 'true' ? true : false;
        //        Section Data
        $order = DB::table('TDocTOrHD')
            ->where('XVOrhDocStatus', '=', '3');
        $order = condition_LCRVOutide($order, 'XVOrhDocNo', $isAllOrder, $OrderStart, $OrderEnd);
        $order = condition_LCR($order, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
        foreach ($order as $item) {
            $OrderHD = DB::table('tdoctgihd')
                ->orderBy('XVGihDocNo', 'asc')
                ->where('XVGihDocStatus', '=', '3')
                ->where('XVGihDocNoOR', '=', $item->XVOrhDocNo)
                ->get();
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $itemSecond->OrderDT = DB::table('tdoctgidt')
                        ->where('XVGihDocNo', '=', $itemSecond->XVGihDocNo)
                        ->select('tdoctgidt.xvmatcode', 'xvuntcode', 'XIGidQty', 'XVGidUnitName', 'XIGidQtyOr', 'xvmatname','XIGidFactor')
                        ->leftJoin('tmstmmaterial', 'tdoctgidt.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
                        ->get();
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($order);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $OrderStart = $request->input('OrderStart');
        $OrderEnd = $request->input('OrderEnd');
        $isAllOrder = $request->input("isAllOrder") === 'true' ? true : false;
        //        Section Data
        $order = DB::table('tdoctgidt')
                 ->Join('tdoctgihd', 'tdoctgidt.XVGihDocNo', 'tdoctgihd.XVGihDocNo')
                 ->Join('TDocTOrHD', 'TDocTOrHD.XVOrhDocNo', 'tdoctgihd.XVGihDocNoOR')
                 ->where('XVOrhDocStatus', '=', '3');
        $order = condition_LCRVOutide($order, 'TDocTOrHD.XVOrhDocNo', $isAllOrder, $OrderStart, $OrderEnd);
        $order = condition_LCR($order, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($order);
    }
}
