<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report307Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index307');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVUserCodeStart = $request->input('XVUserCodeStart');
        $XVUserCodeEnd = $request->input('XVUserCodeEnd');
        $isAllUser = $request->input("isAllUser") === 'true' ? true : false;
        //        Section Data
        $users = DB::table('vk2_users');
        $users = condition_LCR($users, 'id', $isAllUser, $XVUserCodeStart, $XVUserCodeEnd);
        foreach ($users as $item) {
            $OrderHD =DB::table('tdoctgihd')
                ->where('XVGihDocStatus', '=', '3')
                ->where('XIGihUsrID', '=', $item->id);
            $OrderHD = condition_LCR($OrderHD, 'XDGihDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $itemSecond->OrderDT = DB::table('tdoctgidt')
                        ->where('XVGihDocNo', '=', $itemSecond->XVGihDocNo)
                        ->leftJoin('tmstmmaterial', 'tdoctgidt.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
                        ->select('tdoctgidt.xvmatcode', 'xvuntcode', 'XIGidQty', 'XVGidUnitName', 'XIGidQtyOr', 'xvmatname','XIGidFactor')
                        ->get();
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($users);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVUserCodeStart = $request->input('XVUserCodeStart');
        $XVUserCodeEnd = $request->input('XVUserCodeEnd');
        $isAllUser = $request->input("isAllUser") === 'true' ? true : false;
        //        Section Data
        $users = DB::table('tdoctgidt')
                 ->Join('tdoctgihd', 'tdoctgidt.XVGihDocNo', 'tdoctgihd.XVGihDocNo')
                 ->Join('tmstmmaterial','tdoctgidt.xvmatcode','tmstmmaterial.xvmatcode')
                 ->leftJoin('vk2_users', 'tdoctgihd.XIGihUsrID', 'vk2_users.id')
                ->where('XVGihDocStatus', '=', '3');
         $users = condition_LCRVOutide($users, 'tdoctgihd.XIGihUsrID', $isAllUser, $XVUserCodeStart, $XVUserCodeEnd);
         $users = condition_LCR($users, 'XDGihDocDate', $isAllTime, $DateStart, $DateEnd);

        return response()->json($users);
    }
}
