<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report401Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index401');
    }

    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVSplCodeStart = $request->input('XVSplCodeStart');
        $XVSplCodeEnd = $request->input('XVSplCodeEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data

        $customer = DB::table('tmstmcustomer');
        $customer = condition_LCR($customer, 'XVCstCode', $isAllSpl, $XVSplCodeStart, $XVSplCodeEnd);
        foreach ($customer as $item) {
            $OrderHD = DB::table('tdoctfrhd')
                ->where('XVFrhDocStatus', '=', '3')
                ->leftJoin('TDocTOrHD', 'tdoctfrhd.XVFrhDocNoOR', '=', 'TDocTOrHD.XVOrhDocNo')
                ->where('TDocTOrHD.XVCstCode', '=', $item->XVCstCode);
            $OrderHD = condition_LCR($OrderHD, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $OrderDT = DB::table('TDocTOrDT')
                        ->where('XVOrhDocNo', '=', $itemSecond->XVOrhDocNo);
                    $itemSecond->OrderDT = $OrderDT
                        ->leftJoin('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
                        ->get();
                    $FR_DT = DB::table('tdoctfrdt')
                        ->where('XVFrhDocNo', '=', $itemSecond->XVFrhDocNo)
                        ->get();
                    foreach ($itemSecond->OrderDT  as $key => $itemMerge){
                        foreach ($FR_DT  as $key1 => $itemMergeSub){
                            if($itemMerge->xvpdtcode == $itemMergeSub->xvpdtcode && $itemMerge->XVPszName == $itemMergeSub->XVPszName){
                                $itemMerge->XIFrdQty = $itemMergeSub->XIFrdQty;
                                break;
                            }
                        }
                    }
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($customer);
    }

    public function datexcel(Request $request)
    {
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVSplCodeStart = $request->input('XVSplCodeStart');
        $XVSplCodeEnd = $request->input('XVSplCodeEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        $customer = DB::table('TDocTOrDT');
        $customer ->join('tdoctorhd','TDocTOrDT.XVOrhDocNo', '=', 'tdoctorhd.XVOrhDocNo')
                  ->where('XVFrhDocStatus', '=', '3');
        $customer ->join('tmstmcustomer','TDocTOrHD.XVCstCode', '=', 'tmstmcustomer.XVCstCode');
        $customer ->join('tdoctfrhd','tdoctorhd.XVOrhDocNo', '=', 'tdoctfrhd.XVFrhDocNoOR')
                  ->Join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode');
        $customer = condition_LCRVOutide($customer, 'tdoctorhd.XVCstCode', $isAllSpl,$XVSplCodeStart,  $XVSplCodeEnd);
        $customer =  condition_LCR($customer, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
        foreach ($customer  as $itemMergeSub){
            $OrderHD = DB::table('tdoctfrdt')
                ->where('tdoctfrdt.XVFrhDocNo', '=', $itemMergeSub->XVFrhDocNo)
                ->where('tdoctfrdt.XVPszName', '=',  $itemMergeSub->XVPszName)
                ->first();
                $itemMergeSub->XIFrdQty= $OrderHD->XIFrdQty?? 0;
        }
        return response()->json($customer);
    }
}
